/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.internal.module;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.commons.lang3.StringUtils;

/**
 * The Module Configuration Data.
 *
 * @author tonywalmsley
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ModuleConfig {
    /**
     * The Module Configuration Data object
     */
    private Module module;

    /**
     * Default constructor
     */
    public ModuleConfig() {
    }

    /**
     * Accessor
     *
     * @return The Module object
     */
    public Module getModule() {
        return module;
    }

    /**
     * Accessor
     *
     * @param module The Module object
     */
    public void setModule(final Module module) {
        this.module = module;
    }

    public boolean isValid() {
        return module != null && !StringUtils.isEmpty(module.getName());
    }
}
