/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import uk.num.numlib.api.NumAPI;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.RequiredUserVariable;
import uk.num.numlib.exc.NumBadModuleConfigDataException;
import uk.num.numlib.exc.NumBadModuleIdException;
import uk.num.numlib.exc.NumBadMultipartRecordException;
import uk.num.numlib.exc.NumBadRecordException;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumDNSQueryException;
import uk.num.numlib.exc.NumDecryptionException;
import uk.num.numlib.exc.NumInvalidDNSHostException;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumInvalidPopulatorResponseCodeException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.exc.NumMaximumRedirectsExceededException;
import uk.num.numlib.exc.NumNoDecryptionKeyException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.NumNotImplementedException;
import uk.num.numlib.exc.NumPopulatorErrorException;
import uk.num.numlib.exc.NumRecordEncryptionRequiredException;
import uk.num.numlib.exc.NumUnsupportedEncryptionAlgorithmException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.ctx.NumAPIContextBase;
import uk.num.numlib.internal.dns.DNSServices;
import uk.num.numlib.internal.dns.DNSServicesDefaultImpl;
import uk.num.numlib.internal.dns.PossibleMultiPartRecordException;
import uk.num.numlib.internal.modl.ModlServices;
import uk.num.numlib.internal.modl.NumLookupRedirect;
import uk.num.numlib.internal.modl.NumQueryRedirect;
import uk.num.numlib.internal.modl.PopulatorResponse;
import uk.num.numlib.internal.module.ModuleConfig;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.module.ModuleFactory;
import uk.num.numlib.internal.util.EncryptionUtils;
import uk.num.numlib.internal.util.PopulatorRetryConfig;

public class NumAPIImpl
implements NumAPI {
    private static final Logger LOG = LoggerFactory.getLogger(NumAPIImpl.class);
    private static final int MAX_NUMBER_OF_MULTI_PARTS = 30;
    private final AppContext appContext = new AppContext();
    private final ModuleFactory moduleFactory = new ModuleFactory();
    private DNSServices dnsServices;
    private ModlServices modlServices;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public NumAPIImpl() {
        LOG.info("enter - NumAPI()");
        this.dnsServices = new DNSServicesDefaultImpl();
        this.modlServices = new ModlServices();
        LOG.info("NumAPI object created.");
    }

    public NumAPIImpl(DNSServices dnsServices, ModlServices modlServices) {
        LOG.info("enter - NumAPI(dnsServices, modlServices)");
        this.dnsServices = dnsServices;
        this.modlServices = modlServices;
        LOG.info("NumAPI object created.");
    }

    public NumAPIImpl(String dnsHost) throws NumInvalidDNSHostException {
        this();
        LOG.info("enter - NumAPI({})", (Object)dnsHost);
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                Lookup.setDefaultResolver((Resolver)resolver);
            }
        }
        catch (UnknownHostException e) {
            LOG.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        LOG.info("NumAPI object created.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NumAPIImpl(String[] dnsHosts) throws NumInvalidDNSHostException, NumInvalidParameterException {
        this();
        LOG.info("enter - NumAPI({})", (Object)Arrays.toString(dnsHosts));
        if (dnsHosts == null || dnsHosts.length == 0) {
            LOG.error("No DNS hosts supplied.");
            throw new NumInvalidParameterException("No DNS hosts supplied.");
        }
        try {
            if (dnsHosts.length == 1) {
                String dnsHost = dnsHosts[0];
                if (StringUtils.isEmpty((CharSequence)dnsHost)) {
                    LOG.error("Empty hostname in the dnsHosts parameter.");
                    throw new NumInvalidDNSHostException("Empty hostname in the dnsHosts parameter.");
                }
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                Lookup.setDefaultResolver((Resolver)resolver);
            } else {
                ExtendedResolver resolver = new ExtendedResolver(dnsHosts);
                Lookup.setDefaultResolver((Resolver)resolver);
            }
        }
        catch (UnknownHostException e) {
            LOG.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        LOG.info("NumAPI object created.");
    }

    public NumAPIImpl(String dnsHost, int port) throws NumInvalidDNSHostException {
        this();
        LOG.info("NumAPI({}, {})", (Object)dnsHost, (Object)port);
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                resolver.setPort(port);
                Lookup.setDefaultResolver((Resolver)resolver);
                this.setTCPOnly(true);
            }
        }
        catch (UnknownHostException e) {
            LOG.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        LOG.info("NumAPI object created.");
    }

    @Override
    public void setTCPOnly(boolean flag) {
        LOG.info("Use TCP only : {}", (Object)flag);
        Lookup.getDefaultResolver().setTCP(flag);
    }

    @Override
    public void setTopLevelZone(String zone) throws NumInvalidParameterException {
        LOG.info("setTopLevelZone({})", (Object)zone);
        if (StringUtils.isEmpty((CharSequence)zone)) {
            throw new NumInvalidParameterException("zone cannot be null or empty");
        }
        this.appContext.stringConstants.setTopLevelZone(zone);
    }

    @Override
    public NumAPIContext begin(String moduleId, String netString, int timeoutMillis) throws NumBadModuleIdException, NumBadModuleConfigDataException, NumBadURLException, NumInvalidParameterException, NumBadRecordException, NumDNSQueryException, NumInvalidDNSQueryException {
        LOG.info("enter - begin({}, {}, {})", new Object[]{moduleId, netString, timeoutMillis});
        assert (moduleId != null && moduleId.trim().length() > 0);
        assert (netString != null && netString.trim().length() > 0);
        assert (timeoutMillis > 0);
        NumAPIContextBase ctx = new NumAPIContextBase();
        ModuleDNSQueries moduleDNSQueries = this.moduleFactory.getInstance(this.appContext, moduleId, netString);
        ctx.setModuleDNSQueries(moduleDNSQueries);
        Record[] records = this.dnsServices.getConfigFileTXTRecords(this.appContext, moduleId, timeoutMillis);
        if (records == null || records.length == 0) {
            LOG.error("No configuration moduleDNSQueries file available. Check that the moduleDNSQueries ID is correct.: {}", (Object)moduleId);
            throw new NumBadModuleIdException("No configuration moduleDNSQueries file available. Check that the moduleDNSQueries ID is correct.: " + moduleId);
        }
        String configTxt = this.dnsServices.rebuildTXTRecordContent(records).replaceAll("\\\\", "");
        ModuleConfig moduleConfig = this.modlServices.interpretModuleConfig(configTxt);
        if (!moduleConfig.isValid()) {
            LOG.error("The module config file is invalid. {}", (Object)configTxt);
            throw new NumBadModuleConfigDataException("Invalid module config data: " + configTxt);
        }
        ctx.setModuleConfig(moduleConfig);
        LOG.info("Module configuration: {}", (Object)moduleConfig);
        LOG.info("exit - begin()");
        return ctx;
    }

    @Override
    public Future<String> retrieveNumRecord(NumAPIContext ctx, NumAPICallbacks handler, int timeoutMillis) {
        LOG.info("retrieveNumRecord()");
        assert (ctx != null);
        assert (handler != null);
        LOG.info("Submitting background query.");
        Future<String> future = this.executor.submit(() -> {
            String result = this.numLookup(ctx, handler, timeoutMillis);
            if (result == null) {
                LOG.error("Unable to retrieve a NUM record.");
                handler.setLocation(null);
                ctx.setLocation(null);
                return null;
            }
            handler.setResult(result);
            return result;
        });
        LOG.info("Background query running.");
        return future;
    }

    /*
     * Unable to fully structure code
     */
    private String numLookup(NumAPIContext ctx, NumAPICallbacks handler, int timeoutMillis) throws NumBadRecordException, NumRecordEncryptionRequiredException, NumNoDecryptionKeyException, NumUnsupportedEncryptionAlgorithmException, NumDecryptionException, NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException, NumNotImplementedException, NumBadMultipartRecordException, NumInvalidDNSQueryException, NumMaximumRedirectsExceededException, NumNoRecordAvailableException, NumPopulatorErrorException, NumInvalidPopulatorResponseCodeException {
        context = (NumAPIContextBase)ctx;
        context.setLocation(NumAPICallbacks.Location.INDEPENDENT);
        NumAPIImpl.LOG.info("Trying the INDEPENDENT location.");
        moduleConfig = context.getModuleConfig();
        while (true) {
            try {
                while (true) {
                    numRecord = this.getNumRecord(timeoutMillis, context);
                    module = moduleConfig.getModule();
                    if (numRecord != null) break;
                    NumAPIImpl.LOG.info("Lookup returned no result.");
                    rootQuery = context.getModuleDNSQueries().isRootQuery();
                    switch (1.$SwitchMap$uk$num$numlib$api$NumAPICallbacks$Location[context.getLocation().ordinal()]) {
                        case 1: {
                            NumAPIImpl.LOG.info("Trying the MANAGED location.");
                            context.setLocation(NumAPICallbacks.Location.MANAGED);
                            break;
                        }
                        case 2: {
                            if (rootQuery) {
                                if (module.isRprq()) {
                                    NumAPIImpl.LOG.info("Trying the POPULATED location.");
                                    context.setLocation(NumAPICallbacks.Location.POPULATED);
                                    break;
                                }
                                NumAPIImpl.LOG.info("Not configured to use the POPULATED location.");
                                context.setLocation(NumAPICallbacks.Location.STOP);
                                break;
                            }
                            if (module.isBprq()) {
                                NumAPIImpl.LOG.info("Trying the POPULATED location.");
                                context.setLocation(NumAPICallbacks.Location.POPULATED);
                                break;
                            }
                            NumAPIImpl.LOG.info("Not configured to use the POPULATED location.");
                            context.setLocation(NumAPICallbacks.Location.STOP);
                            break;
                        }
                        case 3: {
                            if (!rootQuery) ** GOTO lbl43
                            if (module.isRpsq()) {
                                NumAPIImpl.LOG.info("Trying the POPULATOR.");
                                context.setLocation(NumAPICallbacks.Location.POPULATOR);
                            } else {
                                NumAPIImpl.LOG.info("Not configured to use the POPULATOR.");
                                context.setLocation(NumAPICallbacks.Location.STOP);
                            }
                            ** GOTO lbl49
lbl43:
                            // 1 sources

                            if (module.isBpsq()) {
                                NumAPIImpl.LOG.info("Trying the POPULATOR.");
                                context.setLocation(NumAPICallbacks.Location.POPULATOR);
                            } else {
                                NumAPIImpl.LOG.info("Not configured to use the POPULATOR.");
                                context.setLocation(NumAPICallbacks.Location.STOP);
                            }
                        }
lbl49:
                        // 5 sources

                        case 4: {
                            NumAPIImpl.LOG.info("Trying the POPULATOR.");
                            fromPopulator = this.getNumRecordFromPopulator(timeoutMillis, context);
                            json = this.interpretNumRecord(fromPopulator, context);
                            if (json != null) {
                                this.checkForEncryption(json, handler, context);
                            }
                            return handler.getResult();
                        }
                        case 5: {
                            NumAPIImpl.LOG.info("Processing an ENCRYPTED record.");
                            this.processDecryption(handler.getResult(), handler, context);
                            return handler.getResult();
                        }
                        default: {
                            return null;
                        }
                    }
                }
                json = this.interpretNumRecord(numRecord, context);
                this.checkForEncryption(json, handler, context);
                return handler.getResult();
            }
            catch (NumLookupRedirect numLookupRedirect) {
                context.setLocation(NumAPICallbacks.Location.INDEPENDENT);
                context.handleQueryRedirect(this.appContext, numLookupRedirect.getRedirect(), context);
                continue;
            }
            catch (NumQueryRedirect numQueryRedirect) {
                context.handleQueryRedirect(this.appContext, numQueryRedirect.getRedirect(), context);
                continue;
            }
            break;
        }
    }

    private void checkForEncryption(String jsonResult, NumAPICallbacks handler, NumAPIContextBase context) throws NumRecordEncryptionRequiredException, NumUnsupportedEncryptionAlgorithmException, NumNoDecryptionKeyException {
        if (jsonResult.contains("\"e_\"")) {
            handler.setEncrypted(true);
            handler.setWasEncrypted(true);
            context.setLocation(NumAPICallbacks.Location.ENCRYPTED);
            try {
                String algorithm;
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(jsonResult);
                JsonNode a_ = node.findValue("a_");
                if (a_ == null || a_.asText().trim().length() == 0) {
                    algorithm = context.getModuleConfig().getModule().getDea();
                    if (StringUtils.isEmpty((CharSequence)algorithm)) {
                        LOG.info("No decryption algorithm specified in the NUM record and no default algorithm in the module configuration. Defaulting to AES.");
                        algorithm = "AES";
                    }
                } else {
                    algorithm = a_.asText().trim();
                }
                handler.setEncryptionAlgorithm(algorithm);
                handler.setResult(jsonResult);
                if (!EncryptionUtils.isSupported(algorithm)) {
                    throw new NumUnsupportedEncryptionAlgorithmException(algorithm);
                }
                Key key = handler.getKey();
                if (key == null) {
                    throw new NumNoDecryptionKeyException("A decryption key is required for " + algorithm);
                }
            }
            catch (IOException e) {
                LOG.error("Error parsing JSON String.", (Throwable)e);
            }
        } else {
            handler.setEncrypted(false);
            handler.setWasEncrypted(false);
            if (context.getModuleConfig().getModule().isRer()) {
                LOG.error("Encryption is required but the record was not encrypted.");
                throw new NumRecordEncryptionRequiredException("Encryption is required but the record was not encrypted.");
            }
            handler.setResult(jsonResult);
        }
    }

    @Override
    public void processDecryption(String base64value, NumAPICallbacks handler, NumAPIContextBase context) throws NumDecryptionException, NumNoDecryptionKeyException, NumBadRecordException, NumLookupRedirect, NumQueryRedirect {
        String algorithm = handler.getEncryptionAlgorithm();
        byte[] raw = Base64.getDecoder().decode(base64value);
        Key key = handler.getKey();
        if (key == null) {
            throw new NumNoDecryptionKeyException("A decryption key is required for " + algorithm);
        }
        String decrypted = EncryptionUtils.decrypt(raw, algorithm, key);
        handler.setEncrypted(false);
        this.interpretNumRecord(decrypted, context);
        String interpretedResult = this.modlServices.interpretNumRecord(decrypted);
        handler.setResult(interpretedResult);
    }

    private Record[] getMultiPartRecords(int timeoutMillis, NumAPIContextBase context, String recordLocation) throws NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException {
        LOG.info("getMultiPartRecords(recordLocation={})", (Object)recordLocation);
        Record[] numberOfPartsRecord = this.dnsServices.getRecordFromDns("0." + recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
        if (numberOfPartsRecord == null || numberOfPartsRecord.length == 0) {
            return null;
        }
        String numberOfPartsStr = this.dnsServices.rebuildTXTRecordContent(numberOfPartsRecord);
        if (!numberOfPartsStr.startsWith("parts=")) {
            throw new NumBadMultipartRecordException("Invalid record 0 for multi-part record: " + numberOfPartsStr);
        }
        int numberOfParts = Integer.parseInt(numberOfPartsStr.substring(6));
        if (numberOfParts > 30) {
            throw new NumBadMultipartRecordException("Too many parts for a multi-part record: " + numberOfPartsStr);
        }
        ArrayList<Record> parts = new ArrayList<Record>();
        for (int i = 1; i <= numberOfParts; ++i) {
            Record[] partNRecords = this.dnsServices.getRecordFromDns("" + i + "." + recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
            if (partNRecords == null || partNRecords.length <= 0) continue;
            parts.addAll(Arrays.asList(partNRecords));
        }
        Record[] recordFromDns = parts.toArray(new Record[0]);
        return recordFromDns;
    }

    private String getNumRecordFromPopulator(int timeoutMillis, NumAPIContextBase context) throws NumPopulatorErrorException, NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumBadMultipartRecordException, NumBadRecordException, NumNotImplementedException, NumInvalidDNSQueryException {
        LOG.info("getNumRecordFromPopulator()");
        String recordLocation = context.getModuleDNSQueries().getPopulatorLocation();
        LOG.info("Querying the populator service: {}", (Object)recordLocation);
        String numRecord = null;
        while (numRecord == null && (numRecord = this.getNumRecordNoCache(timeoutMillis, context, recordLocation)) != null) {
            LOG.info("Response from Populator: {}.", (Object)numRecord);
            PopulatorResponse response = this.modlServices.interpretPopulatorResponse(numRecord);
            if (!response.isValid()) {
                throw new NumInvalidPopulatorResponseCodeException("Bad response received from the populator service.");
            }
            if (response.getStatus_() != null) {
                numRecord = this.handlePopulatorStatusCodes(timeoutMillis, context, response);
            }
            if (response.getError_() == null) continue;
            if (response.getError_().getCode() == 100) {
                LOG.error("NUM Populator error: {}, {}", (Object)response.getError_().getCode(), (Object)response.getError_().getDescription());
                try {
                    for (int i = 0; i < PopulatorRetryConfig.ERROR_RETRIES; ++i) {
                        LOG.info("Sleeping for {} seconds.", (Object)PopulatorRetryConfig.ERROR_RETRY_DELAYS[i]);
                        TimeUnit.SECONDS.sleep(PopulatorRetryConfig.ERROR_RETRY_DELAYS[i]);
                        LOG.info("Retrying...");
                        numRecord = this.getNumRecord(timeoutMillis, context);
                        PopulatorResponse retryResponse = this.modlServices.interpretPopulatorResponse(numRecord);
                        if (retryResponse.getStatus_() == null) continue;
                        return this.handlePopulatorStatusCodes(timeoutMillis, context, retryResponse);
                    }
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted", (Throwable)e);
                }
                LOG.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            LOG.error("NUM Populator error: {}, {}", (Object)response.getError_().getCode(), (Object)response.getError_().getDescription());
            throw new NumPopulatorErrorException(response.getError_().getDescription());
        }
        return numRecord;
    }

    private String handlePopulatorStatusCodes(int timeoutMillis, NumAPIContextBase context, PopulatorResponse response) throws NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException {
        LOG.info("handlePopulatorStatusCodes()");
        String numRecord = null;
        switch (response.getStatus_().getCode()) {
            case 1: {
                LOG.info("Populator Status code: 1");
                try {
                    context.setLocation(NumAPICallbacks.Location.POPULATED);
                    for (int i = 0; i < PopulatorRetryConfig.RETRIES; ++i) {
                        LOG.info("Sleeping for {} seconds.", (Object)PopulatorRetryConfig.RETRY_DELAYS[i]);
                        TimeUnit.SECONDS.sleep(PopulatorRetryConfig.RETRY_DELAYS[i]);
                        LOG.info("Retrying...");
                        numRecord = this.getNumRecord(timeoutMillis, context);
                        if (numRecord == null || numRecord.contains("status_") || numRecord.contains("error_")) continue;
                        return numRecord;
                    }
                    LOG.error("Cannot retrieve NUM record from any location.");
                    throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            case 2: {
                LOG.info("Populator Status code: 2");
                context.setLocation(NumAPICallbacks.Location.INDEPENDENT);
                numRecord = this.getNumRecord(timeoutMillis, context);
                if (numRecord != null) break;
                LOG.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            case 3: {
                LOG.info("Populator Status code: 3");
                context.setLocation(NumAPICallbacks.Location.MANAGED);
                numRecord = this.getNumRecord(timeoutMillis, context);
                if (numRecord != null) break;
                LOG.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            case 999: {
                numRecord = response.getNumRecord();
                break;
            }
            default: {
                context.setLocation(null);
                LOG.error("Invalid response code from DNS populator service: {}", (Object)response.getStatus_().getCode());
                throw new NumInvalidPopulatorResponseCodeException("Invalid response code from DNS populator service: " + response.getStatus_().getCode());
            }
        }
        return numRecord;
    }

    private String getInterpretedNumRecordAsJson(String moduleNumber, ModuleConfig moduleConfig, String numRecord) throws NumBadRecordException, NumQueryRedirect, NumLookupRedirect {
        LOG.info("getInterpretedNumRecordAsJson({}, moduleConfig, {})", (Object)moduleNumber, (Object)numRecord);
        StringBuilder numRecordBuffer = new StringBuilder();
        RequiredUserVariable[] ruv = moduleConfig.getModule().getRuv();
        if (ruv != null) {
            for (RequiredUserVariable v : ruv) {
                numRecordBuffer.append(v.getKey());
                numRecordBuffer.append("=");
                numRecordBuffer.append(v.getValue());
                numRecordBuffer.append(";");
            }
        }
        numRecordBuffer.append("*load=\"http://modules.num.uk/");
        numRecordBuffer.append(moduleNumber);
        numRecordBuffer.append("/rcf.txt!\";");
        numRecordBuffer.append(numRecord);
        LOG.info("Interpret NUM record: {}", (Object)numRecordBuffer.toString());
        return this.modlServices.interpretNumRecord(numRecordBuffer.toString());
    }

    private String interpretNumRecord(String numRecord, NumAPIContextBase context) throws NumLookupRedirect, NumBadRecordException, NumQueryRedirect {
        LOG.info("interpretNumRecord({}, context)", (Object)numRecord);
        String json = null;
        if (numRecord != null && numRecord.trim().length() > 0) {
            json = this.getInterpretedNumRecordAsJson(context.getModuleDNSQueries().getModuleId(), context.getModuleConfig(), numRecord);
        }
        return json;
    }

    private String getNumRecord(int timeoutMillis, NumAPIContextBase context) throws NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException {
        Record[] recordFromDns;
        String recordLocation = context.getRecordLocation();
        LOG.info("getNumRecord({}, context, {})", (Object)timeoutMillis, (Object)recordLocation);
        try {
            recordFromDns = this.dnsServices.getRecordFromDns(recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
        }
        catch (PossibleMultiPartRecordException e) {
            LOG.info("Possible multi-part record - checking.");
            recordFromDns = this.getMultiPartRecords(timeoutMillis, context, recordLocation);
        }
        if (recordFromDns == null || recordFromDns.length == 0) {
            return null;
        }
        return this.dnsServices.rebuildTXTRecordContent(recordFromDns);
    }

    private String getNumRecordNoCache(int timeoutMillis, NumAPIContextBase context, String recordLocation) throws NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException {
        Record[] recordFromDns;
        LOG.info("getNumRecordNoCache({}, context, {})", (Object)timeoutMillis, (Object)recordLocation);
        try {
            recordFromDns = this.dnsServices.getRecordFromDnsNoCache(recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
        }
        catch (PossibleMultiPartRecordException e) {
            LOG.info("Possible multi-part record - checking.");
            recordFromDns = this.getMultiPartRecords(timeoutMillis, context, recordLocation);
        }
        if (recordFromDns == null || recordFromDns.length == 0) {
            return null;
        }
        return this.dnsServices.rebuildTXTRecordContent(recordFromDns);
    }

    @Override
    public void shutdown() {
        LOG.info("shutdown()");
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Shutdown interrupted: ", (Throwable)e);
        }
        finally {
            if (!this.executor.isTerminated()) {
                LOG.info("Failed to shutdown after 1 second, so forcing shutdown.");
                this.executor.shutdownNow();
            }
        }
        LOG.info("Shutdown complete.");
    }
}

