/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.internal.util;

/**
 * Constants defined by the NUM Protocol Specification
 *
 * @author tonywalmsley
 */
public final class StringConstants {

    /**
     * The top level zone to use. Can be overridden.
     */
    private String topLevelZone = "num.uk";

    /**
     * The top level zone to use for module config files. Can be overridden.
     */
    private String moduleConfigTopLevelZone = "num.uk";

    /**
     * Constructor
     */
    public StringConstants() {
    }

    /**
     * Override the top-level zone from 'num.uk' to 'myzone.com' for example.
     *
     * @param moduleConfigTopLevelZone The top level zone to use for module config files. Replaces the default of 'num.uk'
     */
    public void setModuleConfigTopLevelZone(final String moduleConfigTopLevelZone) {
        this.moduleConfigTopLevelZone = moduleConfigTopLevelZone;
    }

    /**
     * Override the top-level zone from 'num.uk' to 'myzone.com' for example.
     *
     * @param topLevelZone The top level zone to use for DNS lookups. Replaces the default of 'num.uk'
     */
    public void setTopLevelZone(final String topLevelZone) {
        this.topLevelZone = topLevelZone;
    }

    /**
     * Accessor
     *
     * @return the DOMAIN_NAME_PREFIX value.
     */
    public String DOMAIN_NAME_PREFIX() {
        return "_";
    }

    /**
     * Accessor
     *
     * @return the UTILITY_MODULE_PREFIX value.
     */
    public String UTILITY_MODULE_PREFIX() {
        return ".utility-modules.";
    }

    /**
     * Accessor
     *
     * @return the MANAGED_RECORD_SUFFIX value.
     */
    public String MANAGED_RECORD_SUFFIX() {
        return ".m." + topLevelZone;
    }

    /**
     * Accessor
     *
     * @return the PREPOPULATED_RECORD_SUFFIX value.
     */
    public String PREPOPULATED_RECORD_SUFFIX() {
        return ".p." + topLevelZone;
    }

    /**
     * Accessor
     *
     * @return the POPULATOR_SERVICE_SUFFIX value.
     */
    public String POPULATOR_SERVICE_SUFFIX() {
        return ".q." + topLevelZone;
    }

    /**
     * Accessor
     *
     * @return the CONFIG_FILE_SUFFIX value.
     */
    public String CONFIG_FILE_SUFFIX() {
        return ".modules." + moduleConfigTopLevelZone;
    }
}
