/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.dns;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import uk.num.numlib.exc.NumDNSQueryException;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.NumNotImplementedException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.dns.DNSServices;
import uk.num.numlib.internal.dns.PossibleMultiPartRecordException;
import uk.num.numlib.internal.util.SimpleCache;

public class DNSServicesDefaultImpl
implements DNSServices {
    private static final Logger LOG = LoggerFactory.getLogger(DNSServicesDefaultImpl.class);
    private static Predicate<Record> isCNAMEOrSPFRecord = r -> r.rdataToString().startsWith("v=spf") || r.rdataToString().startsWith("\"v=spf") || r.getType() == 5 || r.getType() == 99;
    private final SimpleCache<String, Record[]> cache = new SimpleCache();

    @Override
    public Record[] getConfigFileTXTRecords(AppContext appContext, String moduleId, int timeoutMillis) throws NumInvalidDNSQueryException, NumDNSQueryException {
        assert (moduleId != null && moduleId.trim().length() > 0);
        assert (timeoutMillis > 0);
        String key = moduleId + "_config";
        Record[] records = this.cache.get(key);
        if (records != null) {
            LOG.trace("Using cached records for {}. There are {} records.", (Object)key, (Object)records.length);
            return records;
        }
        Resolver resolver = Lookup.getDefaultResolver();
        resolver.setTimeout(timeoutMillis / 1000, timeoutMillis % 1000);
        resolver.setIgnoreTruncation(false);
        String query = moduleId + appContext.stringConstants.CONFIG_FILE_SUFFIX();
        try {
            LOG.trace("Retrieving configuration file from DNS using query: {}", (Object)query);
            Lookup lookup = new Lookup(query, 16);
            records = lookup.run();
            if (lookup.getResult() != 0) {
                LOG.error("Error retrieving configuration file from DNS: {} for query {}", (Object)lookup.getErrorString(), (Object)query);
                throw new NumDNSQueryException("Error retrieving configuration file from DNS: " + lookup.getErrorString() + " for query: " + query);
            }
        }
        catch (TextParseException e) {
            LOG.error("Error parsing DNS query.", (Throwable)e);
            throw new NumInvalidDNSQueryException(query);
        }
        this.cache.put(key, records);
        LOG.trace("Caching records for {}. There are {} records.", (Object)key, (Object)records.length);
        return records;
    }

    @Override
    public String rebuildTXTRecordContent(Record[] records) {
        assert (records != null && records.length > 0);
        StringBuilder buffer = new StringBuilder();
        for (Record record : records) {
            TXTRecord txt = (TXTRecord)record;
            List strings = txt.getStrings();
            for (Object string : strings) {
                buffer.append(string);
            }
        }
        LOG.trace("Concatenated {} records to get: {}", (Object)records.length, (Object)buffer.toString());
        return buffer.toString();
    }

    @Override
    public Record[] getRecordFromDns(String query, int timeoutMillis, boolean checkDnsSecValidity) throws NumNotImplementedException, NumInvalidDNSQueryException, NumNoRecordAvailableException {
        assert (query != null && query.trim().length() > 0);
        assert (timeoutMillis > 0);
        Record[] records = this.cache.get(query);
        if (records != null) {
            LOG.trace("Using cached records for {}. There are {} records.", (Object)query, (Object)records.length);
            return records;
        }
        records = this.getRecordFromDnsNoCache(query, timeoutMillis, checkDnsSecValidity);
        if (records != null && records.length > 0) {
            this.cache.put(query, records);
            LOG.trace("Caching records for {}. There are {} records.", (Object)query, (Object)records.length);
        }
        return records;
    }

    @Override
    public Record[] getRecordFromDnsNoCache(String query, int timeoutMillis, boolean checkDnsSecValidity) throws NumNotImplementedException, NumInvalidDNSQueryException, NumNoRecordAvailableException {
        Record[] records;
        block8: {
            assert (query != null && query.trim().length() > 0);
            assert (timeoutMillis > 0);
            Resolver resolver = Lookup.getDefaultResolver();
            resolver.setTimeout(timeoutMillis / 1000, timeoutMillis % 1000);
            resolver.setIgnoreTruncation(false);
            try {
                Record queryTxtRecord = Record.newRecord((Name)new Name(query), (int)16, (int)1);
                Message queryMessage = Message.newQuery((Record)queryTxtRecord);
                LOG.debug("Sending DNS Query: {}", (Object)queryMessage);
                Message response = resolver.send(queryMessage);
                LOG.debug("Received DNS Response: {}", (Object)response);
                if (response.getRcode() == 0) {
                    if (checkDnsSecValidity) {
                        LOG.error("DNSSEC checks not implemented.");
                        throw new NumNotImplementedException("DNSSEC checks not implemented.");
                    }
                    records = response.getSectionArray(1);
                    if (Arrays.stream(records).anyMatch(isCNAMEOrSPFRecord)) {
                        throw new NumNoRecordAvailableException("Received CNAME or SPF record instead of TXT record.");
                    }
                    break block8;
                }
                if (response.getHeader().getFlag(6)) {
                    LOG.info("Response truncated, possible Multi-part record.");
                    throw new PossibleMultiPartRecordException();
                }
                return null;
            }
            catch (IOException e) {
                LOG.error("Error querying for NUM record.", (Throwable)e);
                throw new NumInvalidDNSQueryException("Invalid DNS query: " + query);
            }
        }
        return records;
    }
}

