package uk.num.numlib.internal.modl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * A response from the populator service.
 *
 * @author tonywalmsley
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class PopulatorResponse {
    public static final int VALID_TXT_RECORD_CODE = 999;
    /**
     * Error object
     */
    private PopulatorResponseRecord error_;
    /**
     * Status object
     */
    private PopulatorResponseRecord status_;

    /**
     * The NUM record returned by the DNS responder if it has one less than 2 minutes old.
     */
    private String numRecord;

    /**
     * Default constructor
     */
    public PopulatorResponse() {
    }

    /**
     * Accessor
     *
     * @return the error record
     */
    public PopulatorResponseRecord getError_() {
        return error_;
    }

    /**
     * Accessor
     *
     * @param error_ the error record.
     */
    public void setError_(PopulatorResponseRecord error_) {
        this.error_ = error_;
    }

    /**
     * Accessor
     *
     * @return the status record
     */
    public PopulatorResponseRecord getStatus_() {
        return status_;
    }

    /**
     * Accessor
     *
     * @param status_ the status record.
     */
    public void setStatus_(PopulatorResponseRecord status_) {
        this.status_ = status_;
    }

    public boolean isValid() {
        if (status_ == null && error_ == null) {
            return false;
        }
        if (status_ != null) {
            final int code = status_.getCode();
            if (code < 1 || (code > 3 && code != VALID_TXT_RECORD_CODE)) {
                return false;
            }
        }
        if (error_ != null) {
            final int code = error_.getCode();
            return code >= 100 && code <= 104;
        }
        return true;
    }

    /**
     * Accessor for the NUM record.
     *
     * @return the NUM record String or null
     */
    public String getNumRecord() {
        return numRecord;
    }

    /**
     * Mutator for the nNUM Record
     *
     * @param numRecord the NUM record String or null
     */
    public void setNUMRecord(final String numRecord) {
        this.numRecord = numRecord;
    }
}
