/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import java.net.URL;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.util.HashUtils;

public class URLUtils {
    public String toIndependentRecordQuery(AppContext appContext, URL url, String moduleId) throws NumInvalidParameterException, NumBadURLException {
        this.validateParams(url, moduleId);
        String normalisedDomain = appContext.domainNameUtils.normaliseDomainName(url.getHost());
        String normalisedPath = this.normalisePath(appContext, url.getPath());
        return String.format("%s%s%s%s.", normalisedPath, moduleId, appContext.stringConstants.UTILITY_MODULE_PREFIX(), normalisedDomain);
    }

    private void validateParams(URL url, String moduleId) throws NumInvalidParameterException {
        if (url == null) {
            throw new NumInvalidParameterException("Cannot normalise a null URL");
        }
        if (moduleId == null) {
            throw new NumInvalidParameterException("The moduleId cannot be null");
        }
        if (moduleId.trim().isEmpty()) {
            throw new NumInvalidParameterException("The moduleId cannot be empty");
        }
    }

    public String toManagedRecordQuery(AppContext appContext, URL url, String moduleId) throws NumInvalidParameterException, NumBadURLException {
        this.validateParams(url, moduleId);
        String normalisedDomain = appContext.domainNameUtils.normaliseDomainName(url.getHost());
        String normalisedPath = this.normalisePath(appContext, url.getPath());
        String hashValue = HashUtils.hash(normalisedDomain);
        return String.format("%s%s.%s%s%s%s.", normalisedPath, moduleId, appContext.stringConstants.DOMAIN_NAME_PREFIX(), normalisedDomain, hashValue, appContext.stringConstants.MANAGED_RECORD_SUFFIX());
    }

    public String toPrePopulatedRecordQuery(AppContext appContext, URL url, String moduleId) throws NumInvalidParameterException, NumBadURLException {
        this.validateParams(url, moduleId);
        String normalisedDomain = appContext.domainNameUtils.normaliseDomainName(url.getHost());
        String normalisedPath = this.normalisePath(appContext, url.getPath());
        String hashValue = HashUtils.hash(normalisedDomain);
        return String.format("%s%s.%s%s%s%s.", normalisedPath, moduleId, appContext.stringConstants.DOMAIN_NAME_PREFIX(), normalisedDomain, hashValue, appContext.stringConstants.PREPOPULATED_RECORD_SUFFIX());
    }

    public String toPopulatorQuery(AppContext appContext, URL url, String moduleId) throws NumInvalidParameterException, NumBadURLException {
        this.validateParams(url, moduleId);
        String normalisedDomain = appContext.domainNameUtils.normaliseDomainName(url.getHost());
        String normalisedPath = this.normalisePath(appContext, url.getPath());
        String hashValue = HashUtils.hash(normalisedDomain);
        return String.format("%s%s.%s%s%s%s.", normalisedPath, moduleId, appContext.stringConstants.DOMAIN_NAME_PREFIX(), normalisedDomain, hashValue, appContext.stringConstants.POPULATOR_SERVICE_SUFFIX());
    }

    private String normalisePath(AppContext appContext, String path) {
        String result = "";
        if (path != null && !path.isEmpty()) {
            Object[] pathComponents = path.split("[/.]");
            ArrayUtils.reverse((Object[])pathComponents);
            if (pathComponents.length > 0) {
                result = appContext.stringConstants.DOMAIN_NAME_PREFIX() + StringUtils.join((Object[])pathComponents, (String)".");
                result = result.replaceAll(" ", "_");
            }
        }
        return result;
    }
}

