/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.internal.util;

import org.apache.commons.codec.digest.DigestUtils;

import java.math.BigInteger;

/**
 * Hash function for domain names.
 *
 * @author tonywalmsley
 */
class HashUtils {
    /**
     * Generate a SHA1 hash and base36 encode it, then return the first 3 chars separated by '.' and prefixed by '.'
     * The parameter is not checked and the caller must supply a correct value.
     *
     * @param normalisedDomain java.lang.String the normalised domain name.
     * @return java.lang.String the hash value.
     */
    static String hash(final String normalisedDomain) {
        final byte[] bytes = DigestUtils.sha1(normalisedDomain);
        final String result = new BigInteger(1, bytes).toString(36);
        return String.format(".%s.%s.%s", result.charAt(0), result.charAt(1), result.charAt(2));
    }

}
