/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.ctx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.UserVariable;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.exc.NumMaximumRedirectsExceededException;
import uk.num.numlib.exc.NumUserVariablesException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.module.ModuleConfig;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.util.NonBlankString;

public class NumAPIContextBase
implements NumAPIContext {
    private static final Logger log = LogManager.getLogger(NumAPIContextBase.class);
    private static final int MAX_NUM_REDIRECTS = 3;
    private ModuleDNSQueries moduleDNSQueries;
    private ModuleConfig moduleConfig;
    private int redirectCount = 0;
    private NumAPICallbacks.Location location;

    private int incrementRedirectCount() {
        ++this.redirectCount;
        return this.redirectCount;
    }

    @Override
    public UserVariable[] getRequiredUserVariables() {
        return this.moduleConfig.getModule().getUv();
    }

    @Override
    public void setRequiredUserVariables(UserVariable[] userVariables) throws NumUserVariablesException {
        StringBuilder errors = new StringBuilder();
        boolean errorsFound = false;
        for (UserVariable v : userVariables) {
            if (v.getValue() != null && v.getValue().trim().length() != 0) continue;
            errorsFound = true;
            errors.append("Variable '");
            errors.append(v.getKey());
            errors.append("' should not be null or empty.\n");
            log.trace("Required User Variable: key={}, prompt={}, value={}", (Object)v.getKey(), (Object)v.getName(), (Object)v.getValue());
        }
        if (errorsFound) {
            log.error("Error in Required User Variables: {}", (Object)errors.toString());
            throw new NumUserVariablesException("Error in Required User Variables: " + errors.toString());
        }
        this.moduleConfig.getModule().setUv(userVariables);
    }

    private void handleIndependentQueryRedirect(AppContext appContext, NonBlankString redirectTo) throws NumBadURLException, NumInvalidParameterException, NumInvalidRedirectException {
        try {
            String location = this.moduleDNSQueries.getIndependentRecordLocation();
            log.trace("Redirecting independent record query from '{}' to : '{}'", (Object)location, (Object)redirectTo);
            if (redirectTo.value.startsWith(".")) {
                this.moduleDNSQueries.setRootRedirectIndependentRecordLocation(appContext, NonBlankString.of(redirectTo.value.substring(1)));
            } else if (redirectTo.value.startsWith("^")) {
                int hats;
                for (hats = 0; redirectTo.value.charAt(hats) == '^' && hats < redirectTo.value.length(); ++hats) {
                }
                this.moduleDNSQueries.setRelativeRedirectIndependentRecordLocation(appContext, NonBlankString.of(redirectTo.value.substring(hats)), hats);
            } else {
                this.moduleDNSQueries.redirectIndependentRecordLocationRelativeToCurrent(redirectTo);
            }
            log.trace("Redirected independent record query new value : '{}'", (Object)this.moduleDNSQueries.getIndependentRecordLocation());
        }
        catch (NumInvalidParameterException e) {
            log.debug("Attempted redirect to same location: {}", (Object)this.moduleDNSQueries.getIndependentRecordLocation());
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
    }

    private void handleHostedQueryRedirect(AppContext appContext, NonBlankString redirectTo) throws NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException {
        try {
            String location = this.moduleDNSQueries.getHostedRecordLocation();
            log.trace("Redirecting hosted record query from '{}' to : '{}'", (Object)location, (Object)redirectTo);
            if (redirectTo.value.startsWith(".")) {
                this.moduleDNSQueries.setRootRedirectHostedRecordLocation(appContext, NonBlankString.of(redirectTo.value.substring(1)));
            } else if (redirectTo.value.startsWith("^")) {
                int hats;
                for (hats = 0; redirectTo.value.charAt(hats) == '^' && hats < redirectTo.value.length(); ++hats) {
                }
                this.moduleDNSQueries.setRelativeRedirectHostedRecordLocation(appContext, NonBlankString.of(redirectTo.value.substring(hats)), hats);
            } else {
                this.moduleDNSQueries.redirectHostedRecordLocationRelativeToCurrent(redirectTo);
            }
            log.trace("Redirected hosted record query new value : '{}'", (Object)this.moduleDNSQueries.getHostedRecordLocation());
        }
        catch (NumInvalidParameterException e) {
            log.debug("Attempted redirect to same location: {}", (Object)this.moduleDNSQueries.getHostedRecordLocation());
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
    }

    public String getRecordLocation() {
        switch (this.location) {
            case INDEPENDENT: {
                return this.moduleDNSQueries.getIndependentRecordLocation();
            }
            case HOSTED: {
                return this.moduleDNSQueries.getHostedRecordLocation();
            }
            case POPULATOR: {
                return this.moduleDNSQueries.getPopulatorLocation();
            }
        }
        return "STOP";
    }

    public void handleQueryRedirect(AppContext appContext, NonBlankString redirect, NumAPIContextBase context) throws NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException, NumMaximumRedirectsExceededException {
        log.info("Query Redirected to: {}", (Object)redirect);
        int redirectCount = context.incrementRedirectCount();
        if (redirectCount >= 3) {
            log.error("Maximum Redirects Exceeded. (max={})", (Object)3);
            throw new NumMaximumRedirectsExceededException();
        }
        switch (this.location) {
            case INDEPENDENT: {
                this.handleIndependentQueryRedirect(appContext, redirect);
            }
            case HOSTED: {
                this.handleHostedQueryRedirect(appContext, redirect);
            }
        }
    }

    public ModuleDNSQueries getModuleDNSQueries() {
        return this.moduleDNSQueries;
    }

    public void setModuleDNSQueries(ModuleDNSQueries moduleDNSQueries) {
        this.moduleDNSQueries = moduleDNSQueries;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        this.moduleConfig = moduleConfig;
    }

    public ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public NumAPICallbacks.Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(NumAPICallbacks.Location location) {
        this.location = location;
    }
}

