/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.dns;

import java.io.IOException;
import java.util.List;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import uk.num.numlib.exc.NumDNSQueryException;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumNotImplementedException;
import uk.num.numlib.internal.dns.DNSServices;
import uk.num.numlib.internal.dns.PossibleMultiPartRecordException;
import uk.num.numlib.internal.util.SimpleCache;
import uk.num.numlib.internal.util.StringConstants;

public class DNSServicesDefaultImpl
implements DNSServices {
    private final SimpleCache<String, Record[]> cache = new SimpleCache();

    @Override
    public Record[] getConfigFileTXTRecords(String moduleId, int timeoutMillis) throws NumInvalidDNSQueryException, NumDNSQueryException {
        assert (moduleId != null && moduleId.trim().length() > 0);
        assert (timeoutMillis > 0);
        String key = moduleId + "_config";
        Record[] records = this.cache.get(key);
        if (records != null) {
            return records;
        }
        Resolver resolver = Lookup.getDefaultResolver();
        resolver.setTimeout(timeoutMillis / 1000, timeoutMillis % 1000);
        resolver.setIgnoreTruncation(false);
        String query = moduleId + StringConstants.instance().CONFIG_FILE_SUFFIX();
        try {
            Lookup lookup = new Lookup(query, 16);
            records = lookup.run();
            if (lookup.getResult() != 0) {
                throw new NumDNSQueryException("Error retrieving configuration file from DNS: " + lookup.getErrorString() + " for query: " + query);
            }
        }
        catch (TextParseException e) {
            throw new NumInvalidDNSQueryException(query);
        }
        this.cache.put(key, records);
        return records;
    }

    @Override
    public String rebuildTXTRecordContent(Record[] records) {
        assert (records != null && records.length > 0);
        StringBuilder buffer = new StringBuilder();
        for (Record record : records) {
            TXTRecord txt = (TXTRecord)record;
            List strings = txt.getStrings();
            for (Object string : strings) {
                buffer.append(string);
            }
        }
        return buffer.toString();
    }

    @Override
    public Record[] getRecordFromDns(String query, int timeoutMillis, boolean checkDnsSecValidity) throws NumNotImplementedException, NumInvalidDNSQueryException {
        assert (query != null && query.trim().length() > 0);
        assert (timeoutMillis > 0);
        Record[] records = this.cache.get(query);
        if (records != null) {
            return records;
        }
        Resolver resolver = Lookup.getDefaultResolver();
        resolver.setTimeout(timeoutMillis / 1000, timeoutMillis % 1000);
        resolver.setIgnoreTruncation(false);
        try {
            Record queryTxtRecord = Record.newRecord((Name)new Name(query), (int)16, (int)1);
            Message queryMessage = Message.newQuery((Record)queryTxtRecord);
            Message response = resolver.send(queryMessage);
            if (response.getRcode() == 0) {
                if (checkDnsSecValidity) {
                    throw new NumNotImplementedException("DNSSEC checks not implemented.");
                }
            } else {
                if (response.getHeader().getFlag(6)) {
                    throw new PossibleMultiPartRecordException();
                }
                return null;
            }
            records = response.getSectionArray(1);
        }
        catch (IOException e) {
            throw new NumInvalidDNSQueryException("Invalid DNS query: " + query);
        }
        this.cache.put(query, records);
        return records;
    }
}

