/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.internal.module;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

/**
 * The Module Configuration Data.
 *
 * @author tonywalmsley
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Getter
@Setter
@ToString
public class ModuleConfig {
    /**
     * The Module Configuration Data object
     */
    private Module module;

    public boolean isValid() {
        return module != null && !StringUtils.isEmpty(module.getName());
    }

}
