package uk.num.numlib.internal.util;

import lombok.NonNull;
import uk.num.numlib.internal.ctx.AppContext;

public class DomainLookupGenerator extends BaseLookupGenerator implements LookupGenerator {

    public DomainLookupGenerator(final AppContext appContext, final @NonNull String numId) {
        super(appContext, numId);
        final int i = numId.indexOf("/");
        if (i > -1) {
            branch = transformBranch(numId);
            if (branch != null && ((branch.equals("/") || branch.equals("")))) {
                branch = null;
            }

            domain = normaliseDomainName(numId.substring(0, i));
        } else {
            domain = normaliseDomainName(numId);
        }
    }
}
