package uk.num.numlib.internal.util;

import uk.num.numlib.exc.NumInvalidParameterException;

/**
 * Uitility to guarantee a populated String value - it cannot be just spaces
 */
public class NonBlankString {
    public final String value;

    /**
     * Private - user the of() static method.
     *
     * @param value the String value
     */
    private NonBlankString(final String value) {
        this.value = value;
    }

    /**
     * @param value a String
     * @return a NonEmptyString if the input value is present and not blank
     * @throws NumInvalidParameterException if the input is null or blank.
     */
    public static NonBlankString of(final String value) throws NumInvalidParameterException {
        if (value == null || value.trim()
                .length() == 0) {
            throw new NumInvalidParameterException("value cannot be null or blank");
        }
        return new NonBlankString(value);
    }

    @Override
    public String toString() {
        return value;
    }
}
