/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.internal.util;

import lombok.Getter;
import lombok.Setter;

/**
 * Constants defined by the NUM Protocol Specification
 *
 * @author tonywalmsley
 */
public final class StringConstants {
    public static final String DOMAIN_SEPARATOR = ".";

    /**
     * The top level zone to use. Can be overridden.
     */
    @Getter
    @Setter
    private String topLevelZone = "num.uk";

    /**
     * The top level zone to use. Can be overridden.
     */
    @Getter
    @Setter
    private String populatorTopLevelZone = "populator.num.uk";

    /**
     * The top level zone to use for module config files. Can be overridden.
     */
    @Getter
    @Setter
    private String moduleConfigTopLevelZone = "num.uk";

    /**
     * Used to indicate a requirement for distributing email records across DNS zone files.
     *
     * @return a String
     */
    public String ZONE_DISTRIBUTION_RECORD_PREFIX() {
        return "_n=1;zd=";
    }

    /**
     * Accessor
     *
     * @return the DOMAIN_NAME_PREFIX value.
     */
    public String DOMAIN_NAME_PREFIX() {
        return "_";
    }

    /**
     * /**
     * Accessor
     *
     * @return the DOMAIN_NAME_PREFIX value.
     */
    public String EMAIL_DOMAIN_SEPARATOR() {
        return "e";
    }

    /**
     * Accessor
     *
     * @return the UTILITY_MODULE_PREFIX value.
     */
    public String UTILITY_MODULE_PREFIX() {
        return "._num.";
    }

    /**
     * Accessor
     *
     * @return the HOSTED_RECORD_SUFFIX value.
     */
    public String HOSTED_RECORD_SUFFIX() {
        return StringConstants.DOMAIN_SEPARATOR + topLevelZone;
    }

    /**
     * Accessor
     *
     * @return the POPULATOR_SERVICE_SUFFIX value.
     */
    public String POPULATOR_SERVICE_SUFFIX() {
        return StringConstants.DOMAIN_SEPARATOR + populatorTopLevelZone;
    }

    /**
     * Accessor
     *
     * @return the CONFIG_FILE_SUFFIX value.
     */
    public String CONFIG_FILE_SUFFIX() {
        return ".modules." + moduleConfigTopLevelZone;
    }
}
