package uk.num.numlib.api;

import lombok.Getter;
import lombok.Setter;

/**
 * A definition of a user variable that needs a value obtained from the user.
 *
 * @author tonywalmsley
 */
@Getter
@Setter
public class UserVariable {
    /**
     * The prompt string describing what is needed from the user.
     */
    private String name;
    /**
     * The name of the variable
     */
    private String key;
    /**
     * True if the variable is mandatory
     */
    private boolean req;
    /**
     * The value obtained from the user.
     */
    private String value;
}
