/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.dns;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import uk.num.numlib.exc.NumDNSQueryException;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.NumNotImplementedException;
import uk.num.numlib.exc.RrSetHeaderFormatException;
import uk.num.numlib.exc.RrSetIncompleteException;
import uk.num.numlib.exc.RrSetNoHeadersException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.dns.DNSServices;
import uk.num.numlib.internal.util.NonBlankString;

public class DNSServicesDefaultImpl
implements DNSServices {
    private static final Logger log = LogManager.getLogger(DNSServicesDefaultImpl.class);
    private static Predicate<Record> isCNAMEOrSPFRecord = r -> r.rdataToString().startsWith("v=spf") || r.rdataToString().startsWith("\"v=spf") || r.getType() == 5 || r.getType() == 99;

    @Override
    public Record[] getConfigFileTXTRecords(AppContext appContext, String moduleId, int timeoutMillis) throws NumInvalidDNSQueryException, NumDNSQueryException {
        Record[] records;
        assert (moduleId != null && moduleId.trim().length() > 0);
        assert (timeoutMillis > 0);
        Resolver resolver = Lookup.getDefaultResolver();
        resolver.setTimeout(timeoutMillis / 1000, timeoutMillis % 1000);
        resolver.setIgnoreTruncation(false);
        String query = moduleId + appContext.stringConstants.CONFIG_FILE_SUFFIX();
        try {
            log.trace("Retrieving configuration file from DNS using query: {}", (Object)query);
            Lookup lookup = new Lookup(query, 16);
            records = lookup.run();
            if (lookup.getResult() != 0) {
                log.error("Error retrieving configuration file from DNS: {} for query {}", (Object)lookup.getErrorString(), (Object)query);
                throw new NumDNSQueryException("Error retrieving configuration file from DNS: " + lookup.getErrorString() + " for query: " + query);
            }
        }
        catch (TextParseException e) {
            log.error("Error parsing DNS query.", (Throwable)e);
            throw new NumInvalidDNSQueryException(query);
        }
        return records;
    }

    @Override
    public String rebuildTXTRecordContent(Record[] records) throws RrSetNoHeadersException, RrSetHeaderFormatException, RrSetIncompleteException {
        assert (records != null && records.length > 0);
        StringBuilder buffer = new StringBuilder();
        HashMap<Integer, String> ordered = new HashMap<Integer, String>();
        for (Record r : records) {
            TXTRecord record = (TXTRecord)r;
            List dataParts = record.getStrings();
            StringBuilder mergedDataParts = new StringBuilder();
            for (Object part : dataParts) {
                mergedDataParts.append(part.toString());
            }
            String data = mergedDataParts.toString();
            if (data.contains("|")) {
                String[] parts = data.split("\\|");
                if (parts.length <= 0) continue;
                if (parts[0].contains("/")) {
                    ordered.put(0, data.substring(parts[0].length() + 1));
                    String[] firstParts = parts[0].split("/");
                    if (firstParts.length == 2) {
                        try {
                            int total = Integer.parseInt(firstParts[1]);
                            if (total == records.length) continue;
                            throw new RrSetIncompleteException("Parts and records length do not match, expected $total - $records");
                        }
                        catch (NumberFormatException ex) {
                            throw new RrSetHeaderFormatException("Could not parse total parts ${firstParts[1]}");
                        }
                    }
                    throw new RrSetHeaderFormatException("First part should only contain 1 \"/\", format is incorrect!");
                }
                try {
                    int index = Integer.parseInt(parts[0]) - 1;
                    ordered.put(index, data.substring(parts[0].length() + 1));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new RrSetHeaderFormatException("Could not parse index ${parts[0]}");
                }
            }
            if (records.length == 1) {
                ordered.put(0, data);
                continue;
            }
            throw new RrSetNoHeadersException("Found a record with no header in multi-part records - $records");
        }
        for (int i = 0; i < ordered.size(); ++i) {
            buffer.append((String)ordered.get(i));
        }
        String result = buffer.toString();
        log.debug("Rebuilt DNS records: {}", (Object)result);
        return result;
    }

    @Override
    public Record[] getRecordFromDnsNoCache(NonBlankString query, int timeoutMillis, boolean checkDnsSecValidity) throws NumNotImplementedException, NumInvalidDNSQueryException, NumNoRecordAvailableException {
        Record[] records;
        block6: {
            assert (timeoutMillis > 0);
            Resolver resolver = Lookup.getDefaultResolver();
            resolver.setTimeout(timeoutMillis / 1000, timeoutMillis % 1000);
            resolver.setIgnoreTruncation(false);
            try {
                Record queryTxtRecord = Record.newRecord((Name)new Name(query.value), (int)16, (int)1);
                Message queryMessage = Message.newQuery((Record)queryTxtRecord);
                log.debug("Sending DNS Query: {}", (Object)queryMessage);
                Message response = resolver.send(queryMessage);
                log.debug("Received DNS Response: {}", (Object)response);
                if (response.getRcode() == 0) {
                    if (checkDnsSecValidity) {
                        log.error("DNSSEC checks not implemented.");
                        throw new NumNotImplementedException("DNSSEC checks not implemented.");
                    }
                    records = response.getSectionArray(1);
                    if (Arrays.stream(records).anyMatch(isCNAMEOrSPFRecord)) {
                        throw new NumNoRecordAvailableException("Received CNAME or SPF record instead of TXT record.");
                    }
                    break block6;
                }
                return null;
            }
            catch (IOException e) {
                log.error("Error querying for NUM record.", (Throwable)e);
                throw new NumInvalidDNSQueryException("Invalid DNS query: " + query);
            }
        }
        return records;
    }
}

