package uk.num.numlib.internal.dns;

import org.xbill.DNS.Record;
import uk.num.numlib.exc.*;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.util.NonBlankString;

/**
 * This interface defines the contract for the DNS Service provider.
 *
 * @author tonywalmsley
 */
public interface DNSServices {
    /**
     * Get the Module Configuration from DNS as an array of Records
     *
     * @param appContext    the AppContext
     * @param moduleId      The module Id String
     * @param timeoutMillis The number of milliseconds to wait for a response.
     * @return An array of Records
     * @throws NumInvalidDNSQueryException on error
     * @throws NumDNSQueryException        on error
     */
    Record[] getConfigFileTXTRecords(final AppContext appContext, final String moduleId, final int timeoutMillis) throws
                                                                                                                  NumInvalidDNSQueryException,
                                                                                                                  NumDNSQueryException;

    /**
     * Concatenate an array of TXT record values to a single String
     *
     * @param records The array of Records
     * @return The concatenated result.
     * @throws RrSetNoHeadersException    on error
     * @throws RrSetHeaderFormatException on error
     * @throws RrSetIncompleteException   on error
     */
    String rebuildTXTRecordContent(final Record[] records) throws RrSetNoHeadersException, RrSetHeaderFormatException,
                                                                  RrSetIncompleteException;

    /**
     * Get a NUM record from DNS.
     *
     * @param query               The NUM formatted DNS query.
     * @param timeoutMillis       The number of milliseconds to wait for a response.
     * @param checkDnsSecValidity true if the result should be checked for DNSSEC validity.
     * @return An array of Records
     * @throws NumNotImplementedException    on error
     * @throws NumInvalidDNSQueryException   on error
     * @throws NumNoRecordAvailableException if a CNAME or SPF record is received instead of a TXT record
     */
    Record[] getRecordFromDnsNoCache(NonBlankString query, int timeoutMillis, boolean checkDnsSecValidity) throws
                                                                                                           NumNotImplementedException,
                                                                                                           NumInvalidDNSQueryException,
                                                                                                           NumNoRecordAvailableException;
}
