package uk.num.numlib.internal.util;

import lombok.NonNull;
import uk.num.numlib.internal.ctx.AppContext;

import java.net.MalformedURLException;
import java.net.URL;

public class URLLookupGenerator extends BaseLookupGenerator implements LookupGenerator {

    public URLLookupGenerator(final AppContext appContext, final @NonNull String numId) throws
                                                                                        MalformedURLException {
        super(appContext, numId);

        final URL url = new URL(numId);
        domain = normaliseDomainName(url.getHost());
        branch = url.getPath();
        if (branch != null && ((branch.equals("/") || branch.equals("")))) {
            branch = null;
        } else {
            branch = transformBranch(normalisePath(branch));
        }
    }
}
