/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.ctx;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.RequiredUserVariable;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.exc.NumMaximumRedirectsExceededException;
import uk.num.numlib.exc.NumUserVariablesException;
import uk.num.numlib.internal.module.ModuleConfig;
import uk.num.numlib.internal.module.ModuleDNSQueries;

public class NumAPIContextBase
implements NumAPIContext {
    public static final int MAX_NUM_REDIRECTS = 3;
    private static final Logger LOG = LoggerFactory.getLogger(NumAPIContextBase.class);
    private ModuleDNSQueries moduleDNSQueries;
    private ModuleConfig moduleConfig;
    private int redirectCount = 0;
    private NumAPICallbacks.Location location;

    public NumAPICallbacks.Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(NumAPICallbacks.Location location) {
        this.location = location;
    }

    public int incrementRedirectCount() {
        ++this.redirectCount;
        return this.redirectCount;
    }

    public ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        this.moduleConfig = moduleConfig;
    }

    public ModuleDNSQueries getModuleDNSQueries() {
        return this.moduleDNSQueries;
    }

    public void setModuleDNSQueries(ModuleDNSQueries moduleDNSQueries) {
        this.moduleDNSQueries = moduleDNSQueries;
    }

    @Override
    public RequiredUserVariable[] getRequiredUserVariables() {
        return this.moduleConfig.getModule().getRuv();
    }

    @Override
    public void setRequiredUserVariables(RequiredUserVariable[] requiredUserVariables) throws NumUserVariablesException {
        StringBuilder errors = new StringBuilder();
        boolean errorsFound = false;
        for (RequiredUserVariable v : requiredUserVariables) {
            if (v.getValue() != null && v.getValue().trim().length() != 0) continue;
            errorsFound = true;
            errors.append("Variable '");
            errors.append(v.getKey());
            errors.append("' should not be null or empty.\n");
            LOG.trace("Required User Variable: key={}, prompt={}, value={}", new Object[]{v.getKey(), v.getPrompt(), v.getValue()});
        }
        if (errorsFound) {
            LOG.error("Error in Required User Variables: {}", (Object)errors.toString());
            throw new NumUserVariablesException("Error in Required User Variables: " + errors.toString());
        }
        this.moduleConfig.getModule().setRuv(requiredUserVariables);
    }

    private void handleIndependentQueryRedirect(String redirectTo) throws NumBadURLException, NumInvalidParameterException, NumInvalidRedirectException {
        String location = this.moduleDNSQueries.getIndependentRecordLocation();
        LOG.trace("Redirecting independent record query from '{}' to : '{}'", (Object)location, (Object)redirectTo);
        if (redirectTo.startsWith(".")) {
            this.moduleDNSQueries.setRootRedirectIndependentRecordLocation(redirectTo.substring(1));
        } else if (redirectTo.startsWith("^")) {
            int hats;
            for (hats = 0; redirectTo.charAt(hats) == '^' && hats < redirectTo.length(); ++hats) {
            }
            this.moduleDNSQueries.setRelativeRedirectIndependentRecordLocation(redirectTo.substring(hats), hats);
        } else {
            this.moduleDNSQueries.setIndependentRecordLocation(redirectTo + "." + location);
        }
        LOG.trace("Redirected independent record query new value : '{}'", (Object)this.moduleDNSQueries.getIndependentRecordLocation());
    }

    private void handleManagedQueryRedirect(String redirectTo) throws NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException {
        String location = this.moduleDNSQueries.getManagedRecordLocation();
        LOG.trace("Redirecting managed record query from '{}' to : '{}'", (Object)location, (Object)redirectTo);
        if (redirectTo.startsWith(".")) {
            this.moduleDNSQueries.setRootRedirectManagedRecordLocation(redirectTo.substring(1));
        } else if (redirectTo.startsWith("^")) {
            int hats;
            for (hats = 0; redirectTo.charAt(hats) == '^' && hats < redirectTo.length(); ++hats) {
            }
            this.moduleDNSQueries.setRelativeRedirectManagedRecordLocation(redirectTo.substring(hats), hats);
        } else {
            this.moduleDNSQueries.setManagedRecordLocation(redirectTo + "." + location);
        }
        LOG.trace("Redirected managed record query new value : '{}'", (Object)this.moduleDNSQueries.getManagedRecordLocation());
    }

    private void handlePrepopulatedQueryRedirect(String redirectTo) throws NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException {
        String location = this.moduleDNSQueries.getPrepopulatedRecordLocation();
        LOG.trace("Redirecting populated record query from '{}' to : '{}'", (Object)location, (Object)redirectTo);
        if (redirectTo.startsWith(".")) {
            this.moduleDNSQueries.setRootRedirectPrepopulatedRecordLocation(redirectTo.substring(1));
        } else if (redirectTo.startsWith("^")) {
            int hats;
            for (hats = 0; redirectTo.charAt(hats) == '^' && hats < redirectTo.length(); ++hats) {
            }
            this.moduleDNSQueries.setRelativeRedirectPrepopulatedRecordLocation(redirectTo.substring(hats), hats);
        } else {
            this.moduleDNSQueries.setPrepopulatedRecordLocation(redirectTo + "." + location);
        }
        LOG.trace("Redirected populated record query new value : '{}'", (Object)this.moduleDNSQueries.getPrepopulatedRecordLocation());
    }

    private void handleLookupRedirect(String redirect) throws NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException {
        LOG.trace("Lookup redirect - updating independent, managed, and populated DNS queries.");
        this.handleIndependentQueryRedirect(redirect);
        this.handleManagedQueryRedirect(redirect);
        this.handlePrepopulatedQueryRedirect(redirect);
    }

    public String getRecordLocation() {
        switch (this.location) {
            case INDEPENDENT: {
                return this.moduleDNSQueries.getIndependentRecordLocation();
            }
            case MANAGED: {
                return this.moduleDNSQueries.getManagedRecordLocation();
            }
            case POPULATOR: {
                return this.moduleDNSQueries.getPopulatorLocation();
            }
            case STOP: {
                return "STOP";
            }
            case POPULATED: {
                return this.moduleDNSQueries.getPrepopulatedRecordLocation();
            }
        }
        return "STOP";
    }

    public void handleQueryRedirect(String redirect, NumAPIContextBase context) throws NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException, NumMaximumRedirectsExceededException {
        LOG.info("Query Redirected to: {}", (Object)redirect);
        int redirectCount = context.incrementRedirectCount();
        if (redirectCount >= 3) {
            LOG.error("Maximum Redirects Exceeded. (max={})", (Object)3);
            throw new NumMaximumRedirectsExceededException();
        }
        switch (this.location) {
            case INDEPENDENT: {
                this.handleIndependentQueryRedirect(redirect);
            }
            case MANAGED: {
                this.handleManagedQueryRedirect(redirect);
            }
            case POPULATED: {
                this.handlePrepopulatedQueryRedirect(redirect);
            }
        }
    }
}

