package uk.num.numlib.internal.dns;

import org.xbill.DNS.Record;
import uk.num.numlib.exc.NumDNSQueryException;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumNotImplementedException;

/**
 * This interface defines the contract for the DNS Service provider.
 *
 * @author tonywalmsley
 */
public interface DNSServices {
    /**
     * Get the Module Configuration from DNS as an array of Records
     *
     * @param moduleId      The module Id String
     * @param timeoutMillis The number of milliseconds to wait for a response.
     * @return An array of Records
     * @throws NumInvalidDNSQueryException on error
     * @throws NumDNSQueryException on error
     */
    Record[] getConfigFileTXTRecords(final String moduleId, final int timeoutMillis) throws NumInvalidDNSQueryException,
                                                                                            NumDNSQueryException;

    /**
     * Concatenate an array of TXT record values to a single String
     *
     * @param records The array of Records
     * @return The concatenated result.
     */
    String rebuildTXTRecordContent(final Record[] records);

    /**
     * Get a NUM record from DNS.
     *
     * @param query               The NUM formatted DNS query.
     * @param timeoutMillis       The number of milliseconds to wait for a response.
     * @param checkDnsSecValidity true if the result should be checked for DNSSEC validity.
     * @return An array of Records
     * @throws NumNotImplementedException on error
     * @throws NumInvalidDNSQueryException on error
     */
    Record[] getRecordFromDns(final String query, final int timeoutMillis, final boolean checkDnsSecValidity) throws
                                                                                                              NumNotImplementedException,
                                                                                                              NumInvalidDNSQueryException;

    Record[] getRecordFromDnsNoCache(String query, int timeoutMillis, boolean checkDnsSecValidity) throws
                                                                                                   NumNotImplementedException,
                                                                                                   NumInvalidDNSQueryException;
}
