package uk.num.numlib.internal.modl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * An object to represent a status or error response from the populator service.
 *
 * @author tonywalmsley
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class PopulatorResponseRecord {
    /**
     * The response code.
     */
    private int code;
    /**
     * The response description
     */
    private String description;

    /**
     * Constructor
     */
    public PopulatorResponseRecord() {
    }

    /**
     * Accessor
     *
     * @return the response code
     */
    public int getCode() {
        return code;
    }

    /**
     * Accessor
     *
     * @param code the response code
     */
    public void setCode(int code) {
        this.code = code;
    }

    /**
     * Accessor
     *
     * @return the response description
     */
    public String getDescription() {
        return description;
    }

    /**
     * Accessor
     *
     * @param description the response description
     */
    public void setDescription(String description) {
        this.description = description;
    }
}
