/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.util.HashUtils;

public class EmailAddressUtils {
    public String toIndependentRecordQuery(String emailAddress, String moduleId) throws NumBadURLException, NumInvalidParameterException {
        this.validateParams(emailAddress, moduleId);
        String[] parts = emailAddress.split("@");
        parts[1] = AppContext.domainNameUtils.normaliseDomainName(parts[1]);
        parts[0] = parts[0].replaceAll(" ", "_");
        return String.format("%s.%s%s%s.", parts[0], moduleId, AppContext.stringConstants.UTILITY_MODULE_PREFIX(), parts[1]);
    }

    private void validateParams(String emailAddress, String moduleId) throws NumInvalidParameterException {
        if (emailAddress == null) {
            throw new NumInvalidParameterException("The email address cannot be null");
        }
        if (emailAddress.trim().isEmpty()) {
            throw new NumInvalidParameterException("The email address cannot be empty");
        }
        if (moduleId == null) {
            throw new NumInvalidParameterException("The moduleId cannot be null");
        }
        if (moduleId.trim().isEmpty()) {
            throw new NumInvalidParameterException("The moduleId cannot be empty");
        }
        if (!emailAddress.contains("@")) {
            throw new NumInvalidParameterException("The email address is invalid - missing '@'");
        }
        String[] emailAddressParts = emailAddress.split("@");
        if (emailAddressParts.length != 2 || emailAddressParts[0].isEmpty()) {
            throw new NumInvalidParameterException("The email address is invalid - the local part or the domain name is empty");
        }
    }

    public String toManagedRecordQuery(String emailAddress, String moduleId) throws NumBadURLException, NumInvalidParameterException {
        this.validateParams(emailAddress, moduleId);
        String[] parts = emailAddress.split("@");
        parts[1] = AppContext.domainNameUtils.normaliseDomainName(parts[1]);
        parts[0] = parts[0].replaceAll(" ", "_");
        String hashValue = HashUtils.hash(parts[1]);
        return String.format("%s.%s.%s%s%s%s.", parts[0], moduleId, AppContext.stringConstants.DOMAIN_NAME_PREFIX(), parts[1], hashValue, AppContext.stringConstants.MANAGED_RECORD_SUFFIX());
    }

    public String toPrePopulatedRecordQuery(String emailAddress, String moduleId) throws NumBadURLException, NumInvalidParameterException {
        this.validateParams(emailAddress, moduleId);
        String[] parts = emailAddress.split("@");
        parts[1] = AppContext.domainNameUtils.normaliseDomainName(parts[1]);
        parts[0] = parts[0].replaceAll(" ", "_");
        String hashValue = HashUtils.hash(parts[1]);
        return String.format("%s.%s.%s%s%s%s.", parts[0], moduleId, AppContext.stringConstants.DOMAIN_NAME_PREFIX(), parts[1], hashValue, AppContext.stringConstants.PREPOPULATED_RECORD_SUFFIX());
    }

    public String toPopulatorQuery(String emailAddress, String moduleId) throws NumBadURLException, NumInvalidParameterException {
        this.validateParams(emailAddress, moduleId);
        String[] parts = emailAddress.split("@");
        parts[1] = AppContext.domainNameUtils.normaliseDomainName(parts[1]);
        parts[0] = parts[0].replaceAll(" ", "_");
        String hashValue = HashUtils.hash(parts[1]);
        return String.format("%s.%s.%s%s%s%s.", parts[0], moduleId, AppContext.stringConstants.DOMAIN_NAME_PREFIX(), parts[1], hashValue, AppContext.stringConstants.POPULATOR_SERVICE_SUFFIX());
    }
}

