package uk.num.numlib.internal.util;

import uk.num.numlib.exc.NumDecryptionException;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

/**
 * Encryption utility methods
 *
 * @author tonywalmsley
 */
public class EncryptionUtils {

    /**
     * Check whether a given encryption algorithm is supported
     *
     * @param algorithm the encryption algorithm string
     * @return true if the algorithm is supported
     */
    public static boolean isSupported(final String algorithm) {
        try {
            Cipher.getInstance(algorithm);
        } catch (NoSuchAlgorithmException e) {
            return false;
        } catch (NoSuchPaddingException e) {
            return false;
        }
        return true;
    }

    /**
     * Decrypt the supplied byte[] using the supplied key and algorithm.
     *
     * @param raw       the encrypted byte []
     * @param algorithm tghe algorithm to use for decryption
     * @param key       the Key to use for decryption.
     * @return the decrypted String.
     * @throws NumDecryptionException on decryption errors
     */
    public static String decrypt(final byte[] raw, final String algorithm, final Key key) throws
                                                                                          NumDecryptionException {
        // TODO: implement this
        return null;
    }
}
