/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import uk.num.numlib.exc.RelativePathException;

public final class UrlRelativePathResolver {
    public static String resolve(String base, String redirect) throws RelativePathException {
        String redirectPath;
        String SEP = "/";
        String basePath = base == null ? "" : StringUtils.removeEnd((String)base, (String)"/");
        String string = redirectPath = redirect == null ? "" : redirect;
        if (redirectPath.startsWith("/")) {
            basePath = redirect;
            redirectPath = "";
        }
        String path = redirectPath.length() > 0 ? basePath + "/" + redirectPath : basePath;
        String[] parts = path.split("/");
        Stack<String> pathStack = new Stack<String>();
        for (String part : parts) {
            if (part.equals("..")) {
                if (pathStack.size() == 0) {
                    throw new RelativePathException("Cannot redirect beyond root");
                }
                pathStack.pop();
                continue;
            }
            if (part.equals(".") || part.length() <= 0) continue;
            pathStack.push(part);
        }
        return "/" + String.join((CharSequence)"/", pathStack);
    }
}

