/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.modl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.Tuple2;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.interpreter.Interpreter;
import uk.modl.model.Array;
import uk.modl.model.ArrayItem;
import uk.modl.model.Map;
import uk.modl.model.MapItem;
import uk.modl.model.Modl;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.StringPrimitive;
import uk.modl.model.Structure;
import uk.modl.transforms.JacksonJsonNodeTransform;
import uk.modl.transforms.TransformationContext;
import uk.num.numlib.exc.NumBadRecordException;
import uk.num.numlib.internal.modl.NumLookupRedirect;
import uk.num.numlib.internal.modl.PopulatorResponse;
import uk.num.numlib.internal.modl.PopulatorResponseRecord;

public final class ModlServices {
    private static final Logger log = LogManager.getLogger(ModlServices.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Interpreter interpreter = new Interpreter();

    public String interpretNumRecord(String numRecord, long timeoutSeconds) throws NumBadRecordException, NumLookupRedirect {
        assert (numRecord != null && numRecord.trim().length() > 0);
        log.trace("Interpreting NUM record: {}", (Object)numRecord);
        try {
            TransformationContext ctx = TransformationContext.baseCtx(null, (long)timeoutSeconds);
            Tuple2 interpreted = this.interpreter.apply(ctx, numRecord);
            this.checkForRedirection((Modl)interpreted._2);
            JsonNode jsonNode = new JacksonJsonNodeTransform(ctx).apply((Modl)interpreted._2);
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        catch (Exception e) {
            log.error("Exception during interpretNumRecord().", (Throwable)e);
            throw new NumBadRecordException("Error interpreting NUM record.", e);
        }
    }

    private void checkForRedirection(Modl modlObject) throws NumLookupRedirect {
        if (modlObject.getStructures() != null) {
            for (Structure structure : modlObject.getStructures()) {
                this.findRedirect(structure);
            }
        }
    }

    private void findRedirect(Object structure) throws NumLookupRedirect {
        if (structure instanceof Pair) {
            PairValue value;
            Pair pair = (Pair)structure;
            if ("@R".equals(pair.getKey()) && (value = pair.getValue()) instanceof StringPrimitive) {
                StringPrimitive str = (StringPrimitive)value;
                throw new NumLookupRedirect(str.getValue());
            }
            this.findRedirect(pair.getValue());
        }
        if (structure instanceof Map) {
            Map map = (Map)structure;
            for (MapItem mi : map.getMapItems()) {
                this.findRedirect(mi);
            }
        }
        if (structure instanceof Array) {
            Array array = (Array)structure;
            for (ArrayItem item : array.getArrayItems()) {
                this.findRedirect(item);
            }
        }
    }

    public PopulatorResponse interpretPopulatorResponse(String numRecord) throws NumBadRecordException {
        assert (numRecord != null && numRecord.trim().length() > 0);
        log.trace("Interpreting populator response record: {}", (Object)numRecord);
        try {
            String json = this.interpreter.interpretToPrettyJsonString(numRecord, 2L);
            log.trace("Interpreted populator response: {}", (Object)json);
            PopulatorResponse response = (PopulatorResponse)this.objectMapper.readValue(json, PopulatorResponse.class);
            if (response.isValid() && response.getStatus() == null) {
                PopulatorResponseRecord status = new PopulatorResponseRecord();
                status.setCode(999);
                status.setDescription("TXT Record");
                response.setStatus(status);
                response.setNumRecord(numRecord);
            }
            return response;
        }
        catch (Exception e) {
            log.error("Exception during interpretPopulatorResponse().", (Throwable)e);
            throw new NumBadRecordException("Error interpreting populator response record.", e);
        }
    }
}

