/*
 * Decompiled with CFR 0.152.
 */
package uk.num.net;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import uk.num.net.NUMURLConnection;
import uk.num.numlib.util.BaseLookupGenerator;
import uk.num.numlib.util.LookupGenerator;
import uk.num.validators.NumUriValidator;
import uk.num.validators.ValidationResult;

public final class NumProtocolSupport {
    private static boolean hasEmbeddedTomcat() {
        try {
            Class.forName("org.apache.catalina.webresources.TomcatURLStreamHandlerFactory");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static URL toUrl(String numAddress) throws MalformedURLException {
        LookupGenerator.NumUriComponents components = BaseLookupGenerator.parseNumUriString((String)numAddress);
        ValidationResult validationResult = NumUriValidator.validate((String)components.getDomain(), (int)components.getModuleNumber(), (String)components.getPath());
        if (!validationResult.isValid()) {
            throw new MalformedURLException(numAddress);
        }
        return new URL(components.toString());
    }

    public static void init() {
    }

    static {
        NumStreamHandlerFactory factory = new NumStreamHandlerFactory();
        try {
            URL.setURLStreamHandlerFactory(factory);
        }
        catch (Exception e) {
            System.out.println("There is an existing protocol handler registered - checking for embedded Tomcat...");
            if (NumProtocolSupport.hasEmbeddedTomcat()) {
                try {
                    Class<?> aClass = Class.forName("org.apache.catalina.webresources.TomcatURLStreamHandlerFactory");
                    Method getInstance = aClass.getMethod("getInstance", new Class[0]);
                    Object instance = getInstance.invoke(null, new Object[0]);
                    Method addUserFactory = aClass.getMethod("addUserFactory", URLStreamHandlerFactory.class);
                    addUserFactory.invoke(instance, factory);
                    System.out.println("Added the NUM protocol handler with the TomcatURLStreamHandlerFactory.");
                }
                catch (Exception ex) {
                    System.err.println("There is an existing protocol handler registered - cannot register the NUM protocol handler with the TomcatURLStreamHandlerFactory.");
                    System.err.println("Error: " + ex.getMessage());
                }
            }
            System.err.println("There is an existing protocol handler registered - cannot register the NUM protocol handler.");
        }
    }

    private static class NumStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private NumStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if ("num".equalsIgnoreCase(protocol)) {
                return new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) {
                        return new NUMURLConnection(u);
                    }
                };
            }
            return null;
        }
    }
}

