/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import uk.num.net.NumProtocolSupport;
import uk.num.numlib.api.NumAPI;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.UserVariable;
import uk.num.numlib.dns.DNSServices;
import uk.num.numlib.dns.DNSServicesDefaultImpl;
import uk.num.numlib.exc.NumBadRecordException;
import uk.num.numlib.exc.NumInvalidDNSHostException;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumInvalidPopulatorResponseCodeException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.exc.NumMaximumRedirectsExceededException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.NumPopulatorErrorException;
import uk.num.numlib.exc.RrSetHeaderFormatException;
import uk.num.numlib.exc.RrSetIncompleteException;
import uk.num.numlib.exc.RrSetNoHeadersException;
import uk.num.numlib.internal.ctx.NumAPIContextBase;
import uk.num.numlib.internal.modl.ModlServices;
import uk.num.numlib.internal.modl.NumLookupRedirect;
import uk.num.numlib.internal.modl.PopulatorResponse;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.module.ModuleFactory;
import uk.num.numlib.internal.util.LegacyEscapeReplacer;
import uk.num.numlib.internal.util.PopulatorRetryConfig;

public final class NumAPIImpl
implements NumAPI {
    private static final Logger log = LogManager.getLogger(NumAPIImpl.class);
    public static final String MATCH_NUM_RECORDS = "(@n=[0-9]+;.*)|(^\\d+\\|.*)|(\\d+/\\d+\\|@n=\\d+;.*)";
    private final ModuleFactory moduleFactory = new ModuleFactory();
    private final LegacyEscapeReplacer legacyEscapeReplacer;
    private final ModlServices modlServices;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private DNSServices dnsServices;
    private String modulesLocation = "https://modules.numprotocol.com/";

    public NumAPIImpl() {
        log.info("enter - NumAPI()");
        this.dnsServices = new DNSServicesDefaultImpl();
        this.modlServices = new ModlServices();
        log.info("NumAPI object created.");
        this.legacyEscapeReplacer = new LegacyEscapeReplacer();
    }

    public NumAPIImpl(DNSServices dnsServices, String dnsHost) throws NumInvalidDNSHostException {
        this();
        this.dnsServices = dnsServices;
        log.info("enter - NumAPI({})", (Object)dnsHost);
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                Lookup.setDefaultResolver((Resolver)resolver);
            }
        }
        catch (UnknownHostException e) {
            log.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        log.info("NumAPI object created.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NumAPIImpl(String[] dnsHosts) throws NumInvalidDNSHostException, NumInvalidParameterException {
        this();
        log.info("enter - NumAPI({})", (Object)Arrays.toString(dnsHosts));
        if (dnsHosts == null || dnsHosts.length == 0) {
            log.error("No DNS hosts supplied.");
            throw new NumInvalidParameterException("No DNS hosts supplied.");
        }
        try {
            if (dnsHosts.length == 1) {
                String dnsHost = dnsHosts[0];
                if (StringUtils.isEmpty((CharSequence)dnsHost)) {
                    log.error("Empty hostname in the dnsHosts parameter.");
                    throw new NumInvalidDNSHostException("Empty hostname in the dnsHosts parameter.");
                }
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                Lookup.setDefaultResolver((Resolver)resolver);
            } else {
                ExtendedResolver resolver = new ExtendedResolver(dnsHosts);
                Lookup.setDefaultResolver((Resolver)resolver);
            }
        }
        catch (UnknownHostException e) {
            log.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        log.info("NumAPI object created.");
    }

    public NumAPIImpl(String dnsHost, int port) throws NumInvalidDNSHostException {
        this();
        log.info("NumAPI({}, {})", (Object)dnsHost, (Object)port);
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                resolver.setPort(port);
                Lookup.setDefaultResolver((Resolver)resolver);
                this.setTCPOnly(true);
            }
        }
        catch (UnknownHostException e) {
            log.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        log.info("NumAPI object created.");
    }

    @Override
    public void setTCPOnly(boolean flag) {
        log.info("Use TCP only : {}", (Object)flag);
        Lookup.getDefaultResolver().setTCP(flag);
    }

    @Override
    public NumAPIContext begin(@NonNull String numAddress, int timeoutMillis) throws MalformedURLException, NumInvalidParameterException {
        if (numAddress == null) {
            throw new NullPointerException("numAddress is marked @NonNull but is null");
        }
        URL url = NumProtocolSupport.toUrl(numAddress);
        return this.begin(url, timeoutMillis);
    }

    @Override
    public NumAPIContext begin(@NonNull URL numAddress, int timeoutMillis) throws MalformedURLException, NumInvalidParameterException {
        if (numAddress == null) {
            throw new NullPointerException("numAddress is marked @NonNull but is null");
        }
        if (!"num".equalsIgnoreCase(numAddress.getProtocol())) {
            throw new MalformedURLException("The URL protocol must be 'num'");
        }
        String path = StringUtils.isBlank((CharSequence)numAddress.getPath()) ? "/" : numAddress.getPath();
        String numId = numAddress.getUserInfo() != null ? numAddress.getUserInfo() + "@" + numAddress.getHost() + path : numAddress.getHost() + path;
        int moduleNumber = numAddress.getPort() > -1 ? numAddress.getPort() : 0;
        log.info("enter - begin({}, {}, {})", (Object)moduleNumber, (Object)numId, (Object)timeoutMillis);
        assert (timeoutMillis > 0);
        NumAPIContextBase ctx = new NumAPIContextBase();
        ModuleDNSQueries moduleDNSQueries = this.moduleFactory.getInstance(moduleNumber, numId);
        ctx.setModuleDNSQueries(moduleDNSQueries);
        log.info("exit - begin()");
        return ctx;
    }

    @Override
    public Future<String> retrieveNumRecord(NumAPIContext ctx, NumAPICallbacks handler, int timeoutMillis) {
        log.info("retrieveNumRecord()");
        assert (ctx != null);
        assert (handler != null);
        log.info("Submitting background query.");
        Future<String> future = this.executor.submit(() -> {
            String result = this.numLookup(ctx, handler, timeoutMillis);
            if (result == null) {
                log.info("Unable to retrieve a NUM record.");
                handler.setLocation(null);
                ctx.setLocation(null);
                return null;
            }
            handler.setResult(result);
            handler.setLocation(ctx.getLocation());
            handler.setSignedDNSSEC(ctx.isDnsSecSigned());
            return result;
        });
        log.info("Background query running.");
        return future;
    }

    private String numLookup(NumAPIContext ctx, NumAPICallbacks handler, int timeoutMillis) throws NumBadRecordException, NumInvalidRedirectException, NumInvalidDNSQueryException, NumMaximumRedirectsExceededException, NumNoRecordAvailableException, NumPopulatorErrorException, NumInvalidPopulatorResponseCodeException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException {
        NumAPIContextBase context = (NumAPIContextBase)ctx;
        context.setLocation(NumAPICallbacks.Location.INDEPENDENT);
        log.info("Trying the INDEPENDENT location.");
        while (true) {
            try {
                String numRecord;
                block14: {
                    block8: while (true) {
                        Optional<String> maybeZDR;
                        if ((numRecord = this.getNumRecord(timeoutMillis, context)) != null && !numRecord.matches(MATCH_NUM_RECORDS)) {
                            numRecord = null;
                        }
                        if ((maybeZDR = Optional.ofNullable(numRecord).filter(this.isZoneDistributionRecord())).isPresent()) {
                            Optional<String> maybeNewLookupResult = maybeZDR.map(this.removeZDRPrefix()).map(Integer::parseInt).map(this.checkRangeAndLogErrors(context, numRecord)).filter(this.validZDRRange()).map(this.handleZoneDistributionRecord(context)).map(s -> {
                                try {
                                    return this.getNumRecord(timeoutMillis, context);
                                }
                                catch (Exception e) {
                                    log.error("Failed in lookup: {}", (Object)context.getRecordLocation());
                                    return null;
                                }
                            });
                            numRecord = maybeNewLookupResult.orElse(null);
                        }
                        if (numRecord != null) break block14;
                        log.info("Lookup returned no result.");
                        switch (context.getLocation()) {
                            case INDEPENDENT: {
                                if (context.getModuleDNSQueries().getModuleId() != 0) {
                                    log.info("Trying the HOSTED location.");
                                    context.setLocation(NumAPICallbacks.Location.HOSTED);
                                    continue block8;
                                }
                                log.info("Module 0 skipping the HOSTED location.");
                                context.setLocation(NumAPICallbacks.Location.STOP);
                                return null;
                            }
                            case HOSTED: {
                                if (context.isPopulatorQueryRequired() && context.getModuleDNSQueries().isRootQuery()) {
                                    log.info("Trying the POPULATOR location.");
                                    context.setLocation(NumAPICallbacks.Location.POPULATOR);
                                } else {
                                    log.info("Not configured to use the POPULATOR location.");
                                    context.setLocation(NumAPICallbacks.Location.STOP);
                                    return null;
                                }
                            }
                            case POPULATOR: {
                                log.info("Trying the POPULATOR.");
                                String fromPopulator = this.getNumRecordFromPopulator(timeoutMillis, context, handler);
                                String json = this.interpretNumRecord(fromPopulator, context, timeoutMillis);
                                handler.setResult(json);
                                return handler.getResult();
                            }
                        }
                        break;
                    }
                    return null;
                }
                String json = this.interpretNumRecord(numRecord, context, timeoutMillis);
                handler.setResult(json);
                return handler.getResult();
            }
            catch (NumLookupRedirect numLookupRedirect) {
                context.setLocation(NumAPICallbacks.Location.INDEPENDENT);
                context.handleQueryRedirect(numLookupRedirect.getRedirect());
                continue;
            }
            break;
        }
    }

    private Function<Integer, String> handleZoneDistributionRecord(NumAPIContextBase context) {
        return n -> {
            log.info("Handling a Zone Distribution Record for {}", (Object)context.getRecordLocation());
            try {
                context.getModuleDNSQueries().setEmailRecordDistributionLevels((int)n);
            }
            catch (NumInvalidParameterException e) {
                log.error("Invalid parameter.", (Throwable)e);
            }
            return context.getRecordLocation();
        };
    }

    private Predicate<Integer> validZDRRange() {
        return n -> n > 0 && n <= 3;
    }

    private Function<Integer, Integer> checkRangeAndLogErrors(NumAPIContextBase context, String numRecord) {
        return n -> {
            if (n < 1 || n > 3) {
                log.error("Invalid Zone Distribution Record number of levels in '{}' when looking up '{}'", (Object)numRecord, (Object)context.getRecordLocation());
            }
            return n;
        };
    }

    private Function<String, String> removeZDRPrefix() {
        return s -> s.substring("@n=1;zd=".length());
    }

    private Predicate<String> isZoneDistributionRecord() {
        return s -> s.startsWith("@n=1;zd=");
    }

    private String getNumRecordFromPopulator(int timeoutMillis, NumAPIContextBase context, NumAPICallbacks handler) throws NumPopulatorErrorException, NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumBadRecordException, NumInvalidDNSQueryException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException {
        log.info("getNumRecordFromPopulator()");
        String recordLocation = context.getModuleDNSQueries().getPopulatorLocation();
        if (recordLocation == null) {
            return null;
        }
        log.info("Querying the populator service: {}", (Object)recordLocation);
        String numRecord = null;
        while (numRecord == null && (numRecord = this.getNumRecordNoCache(timeoutMillis, recordLocation, context)) != null) {
            log.info("Response from Populator: {}.", (Object)numRecord);
            PopulatorResponse response = this.modlServices.interpretPopulatorResponse(numRecord);
            if (response.isValid()) {
                throw new NumInvalidPopulatorResponseCodeException("Bad response received from the populator service.");
            }
            if (response.getStatus() != null) {
                numRecord = this.handlePopulatorStatusCodes(timeoutMillis, context, response, handler);
            }
            if (response.getError() == null) continue;
            if (response.getError().getCode() == 100) {
                log.error("NUM Populator error: {}, {}", (Object)response.getError().getCode(), (Object)response.getError().getDescription());
                try {
                    for (int i = 0; i < PopulatorRetryConfig.ERROR_RETRIES; ++i) {
                        log.info("Sleeping for {} seconds.", (Object)PopulatorRetryConfig.ERROR_RETRY_DELAYS[i]);
                        TimeUnit.MILLISECONDS.sleep(PopulatorRetryConfig.ERROR_RETRY_DELAYS[i]);
                        log.info("Retrying...");
                        numRecord = this.getNumRecord(timeoutMillis, context);
                        PopulatorResponse retryResponse = this.modlServices.interpretPopulatorResponse(numRecord);
                        if (retryResponse.getStatus() == null) continue;
                        return this.handlePopulatorStatusCodes(timeoutMillis, context, retryResponse, handler);
                    }
                }
                catch (InterruptedException e) {
                    log.error("Interrupted", (Throwable)e);
                }
                log.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            log.error("NUM Populator error: {}, {}", (Object)response.getError().getCode(), (Object)response.getError().getDescription());
            throw new NumPopulatorErrorException(response.getError().getDescription());
        }
        return numRecord;
    }

    private String handlePopulatorStatusCodes(int timeoutMillis, NumAPIContextBase context, PopulatorResponse response, NumAPICallbacks handler) throws NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumInvalidDNSQueryException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException {
        log.info("handlePopulatorStatusCodes()");
        String numRecord = null;
        switch (response.getStatus().getCode()) {
            case 1: {
                log.info("Populator Status code: 1");
                try {
                    context.setLocation(NumAPICallbacks.Location.POPULATOR);
                    for (int i = 0; i < PopulatorRetryConfig.RETRY_DELAYS.length; ++i) {
                        log.info("Sleeping for {} seconds.", (Object)PopulatorRetryConfig.RETRY_DELAYS[i]);
                        TimeUnit.MILLISECONDS.sleep(PopulatorRetryConfig.RETRY_DELAYS[i]);
                        log.info("Retrying...");
                        numRecord = this.getNumRecord(timeoutMillis, context);
                        if (numRecord == null || numRecord.contains("@status") || numRecord.contains("@error")) continue;
                        try {
                            String interpretNumRecord = this.interpretNumRecord(numRecord, context, timeoutMillis);
                            handler.setResult(interpretNumRecord);
                            continue;
                        }
                        catch (Exception e) {
                            log.error("Error in response from the populator.", (Throwable)e);
                        }
                    }
                    if (numRecord != null && (numRecord.contains("@status") || !numRecord.contains("@error"))) {
                        log.error("Cannot retrieve NUM record from any location.");
                        throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
                    }
                    return numRecord;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            case 2: {
                log.info("Populator Status code: 2");
                context.setLocation(NumAPICallbacks.Location.INDEPENDENT);
                numRecord = this.getNumRecord(timeoutMillis, context);
                if (numRecord != null) break;
                log.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            case 3: {
                log.info("Populator Status code: 3");
                context.setLocation(NumAPICallbacks.Location.HOSTED);
                numRecord = this.getNumRecord(timeoutMillis, context);
                if (numRecord != null) break;
                log.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            case 999: {
                numRecord = response.getNumRecord();
                break;
            }
            default: {
                context.setLocation(null);
                log.error("Invalid response code from DNS populator service: {}", (Object)response.getStatus().getCode());
                throw new NumInvalidPopulatorResponseCodeException("Invalid response code from DNS populator service: " + response.getStatus().getCode());
            }
        }
        return numRecord;
    }

    private String getInterpretedNumRecordAsJson(int moduleNumber, NumAPIContext context, String numRecord, int timeoutMillis) throws NumBadRecordException, NumLookupRedirect {
        log.info("getInterpretedNumRecordAsJson({}, {})", (Object)moduleNumber, (Object)numRecord);
        StringBuilder numRecordBuffer = new StringBuilder();
        UserVariable[] ruv = context.getRequiredUserVariables();
        if (ruv != null) {
            for (UserVariable v : ruv) {
                numRecordBuffer.append(v.getKey());
                numRecordBuffer.append("=");
                numRecordBuffer.append(v.getValue());
                numRecordBuffer.append(";");
            }
        }
        if (moduleNumber > 0) {
            numRecordBuffer.append("*load=\"");
            numRecordBuffer.append(this.modulesLocation);
            numRecordBuffer.append(moduleNumber);
            numRecordBuffer.append("/rcf.txt!\";");
        }
        numRecordBuffer.append(this.legacyEscapeReplacer.apply(numRecord));
        log.info("Interpret NUM record: {}", (Object)numRecordBuffer.toString());
        return this.modlServices.interpretNumRecord(numRecordBuffer.toString(), timeoutMillis);
    }

    private String interpretNumRecord(String numRecord, NumAPIContextBase context, int timeoutMillis) throws NumLookupRedirect, NumBadRecordException {
        log.info("interpretNumRecord({}, context)", (Object)numRecord);
        String json = null;
        if (numRecord != null && numRecord.trim().length() > 0) {
            json = this.getInterpretedNumRecordAsJson(context.getModuleDNSQueries().getModuleId(), context, numRecord, timeoutMillis);
        }
        return json;
    }

    private String getNumRecord(int timeoutMillis, NumAPIContextBase context) throws NumInvalidDNSQueryException, NumNoRecordAvailableException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException {
        String recordLocation = context.getRecordLocation();
        if (recordLocation == null) {
            return null;
        }
        log.info("getNumRecord({}, context, {})", (Object)timeoutMillis, (Object)recordLocation);
        DNSServices.GetRecordResponse recordFromDns = this.dnsServices.getRecordFromDnsNoCache(recordLocation, timeoutMillis);
        if (recordFromDns == null || recordFromDns.getRecords().length == 0) {
            return null;
        }
        context.setDnsSecSigned(recordFromDns.isSigned());
        return this.dnsServices.rebuildTXTRecordContent(recordFromDns.getRecords());
    }

    private String getNumRecordNoCache(int timeoutMillis, String recordLocation, NumAPIContextBase context) throws NumInvalidDNSQueryException, NumNoRecordAvailableException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException {
        log.info("getNumRecordNoCache({}, context, {})", (Object)timeoutMillis, (Object)recordLocation);
        DNSServices.GetRecordResponse recordFromDns = this.dnsServices.getRecordFromDnsNoCache(recordLocation, timeoutMillis);
        if (recordFromDns == null || recordFromDns.getRecords().length == 0) {
            return null;
        }
        context.setDnsSecSigned(recordFromDns.isSigned());
        return this.dnsServices.rebuildTXTRecordContent(recordFromDns.getRecords());
    }

    @Override
    public void shutdown() {
        log.info("shutdown()");
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Shutdown interrupted: ", (Throwable)e);
        }
        finally {
            if (!this.executor.isTerminated()) {
                log.info("Failed to shutdown after 1 second, so forcing shutdown.");
                this.executor.shutdownNow();
            }
        }
        log.info("Shutdown complete.");
    }

    public void setModulesLocation(String modulesLocation) {
        this.modulesLocation = modulesLocation;
    }
}

