/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.module;

import java.net.MalformedURLException;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.util.BaseLookupGenerator;
import uk.num.numlib.internal.util.DomainLookupGenerator;
import uk.num.numlib.internal.util.EmailLookupGenerator;
import uk.num.numlib.internal.util.NonBlankString;
import uk.num.numlib.internal.util.URLLookupGenerator;

public final class ModuleDNSQueries {
    private static final Logger log = LogManager.getLogger(ModuleDNSQueries.class);
    @NonNull
    private final String moduleId;
    @NonNull
    private final String numId;
    private String independentRecordLocation;
    private String rootIndependentRecordLocation;
    private String hostedRecordLocation;
    private String rootHostedRecordLocation;
    private String populatorLocation;
    private boolean rootQuery = true;

    public ModuleDNSQueries(@NonNull NonBlankString moduleId, @NonNull NonBlankString numId) {
        if (moduleId == null) {
            throw new NullPointerException("moduleId is marked @NonNull but is null");
        }
        if (numId == null) {
            throw new NullPointerException("numId is marked @NonNull but is null");
        }
        log.debug("ModuleDNSQueries({}, {})", (Object)moduleId, (Object)numId);
        this.moduleId = moduleId.value;
        this.numId = numId.value;
    }

    public void initialise(AppContext appContext) throws MalformedURLException {
        log.trace("initialise()");
        BaseLookupGenerator lookupGenerator = this.numId.contains("@") ? new EmailLookupGenerator(appContext, this.numId) : (this.numId.startsWith("http") ? new URLLookupGenerator(appContext, this.numId) : new DomainLookupGenerator(appContext, this.numId));
        this.independentRecordLocation = lookupGenerator.getIndependentLocation(this.moduleId);
        this.rootIndependentRecordLocation = lookupGenerator.getRootIndependentLocation(this.moduleId);
        this.hostedRecordLocation = lookupGenerator.getHostedLocation(this.moduleId);
        this.rootHostedRecordLocation = lookupGenerator.getRootHostedLocation(this.moduleId);
        this.rootQuery = lookupGenerator.isDomainRoot();
        if (this.rootQuery) {
            this.populatorLocation = lookupGenerator.getPopulatorLocation(this.moduleId);
        }
    }

    public void setEmailRecordDistributionLevels(AppContext appContext, int levels) {
        if (this.numId.contains("@")) {
            EmailLookupGenerator generator = new EmailLookupGenerator(appContext, this.numId);
            this.independentRecordLocation = generator.getDistributedIndependentLocation(this.moduleId, levels);
            this.hostedRecordLocation = generator.getDistributedHostedLocation(this.moduleId, levels);
        } else {
            log.warn("Attempt to distribute a non-email lookup using a Zone Distribution Record.");
        }
    }

    public String getHostedRecordPath() throws NumInvalidDNSQueryException {
        int index = this.hostedRecordLocation.indexOf(this.rootHostedRecordLocation);
        if (index > -1) {
            return this.toPath(this.hostedRecordLocation.substring(0, index));
        }
        throw new NumInvalidDNSQueryException(String.format("Invalid hosted record location: %s", this.hostedRecordLocation));
    }

    public String getIndependentRecordPath() throws NumInvalidDNSQueryException {
        int index = this.independentRecordLocation.indexOf(this.rootIndependentRecordLocation);
        if (index > -1) {
            return this.toPath(this.independentRecordLocation.substring(0, index));
        }
        throw new NumInvalidDNSQueryException(String.format("Invalid independent record location: %s", this.independentRecordLocation));
    }

    private String toPath(@NonNull String domainPath) {
        if (domainPath == null) {
            throw new NullPointerException("domainPath is marked @NonNull but is null");
        }
        if (domainPath.contains(".")) {
            Object[] parts = domainPath.split("\\.");
            ArrayUtils.reverse((Object[])parts);
            return "/" + String.join((CharSequence)"/", (CharSequence[])parts);
        }
        return "/" + domainPath;
    }

    public void redirectHostedPath(String path) throws NumInvalidRedirectException {
        String newLocation;
        String string = newLocation = "/".equals(path) ? this.rootHostedRecordLocation : this.fromPath(path) + "." + this.rootHostedRecordLocation;
        if (newLocation.equals(this.hostedRecordLocation)) {
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.hostedRecordLocation = newLocation;
    }

    public void redirectIndependentPath(String path) throws NumInvalidRedirectException {
        String newLocation;
        String string = newLocation = "/".equals(path) ? this.rootIndependentRecordLocation : this.fromPath(path) + "." + this.rootIndependentRecordLocation;
        if (newLocation.equals(this.independentRecordLocation)) {
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.independentRecordLocation = newLocation;
    }

    private String fromPath(String path) {
        if (path.contains("/")) {
            Object[] parts = path.split("/");
            ArrayUtils.reverse((Object[])parts);
            CharSequence[] partsWithoutEmptyStrings = (String[])ArrayUtils.removeAllOccurences((Object[])parts, (Object)"");
            return String.join((CharSequence)".", partsWithoutEmptyStrings);
        }
        return path;
    }

    @NonNull
    public String getModuleId() {
        return this.moduleId;
    }

    public String getIndependentRecordLocation() {
        return this.independentRecordLocation;
    }

    public String getRootIndependentRecordLocation() {
        return this.rootIndependentRecordLocation;
    }

    public String getHostedRecordLocation() {
        return this.hostedRecordLocation;
    }

    public String getRootHostedRecordLocation() {
        return this.rootHostedRecordLocation;
    }

    public String getPopulatorLocation() {
        return this.populatorLocation;
    }

    public boolean isRootQuery() {
        return this.rootQuery;
    }
}

