/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.module;

import java.net.MalformedURLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.util.NonBlankString;
import uk.num.numlib.internal.util.SimpleCache;

public final class ModuleFactory {
    private static final Logger log = LogManager.getLogger(ModuleFactory.class);
    private final SimpleCache<String, ModuleDNSQueries> moduleMap = new SimpleCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDNSQueries getInstance(AppContext appContext, NonBlankString moduleName, NonBlankString numId) throws MalformedURLException {
        ModuleDNSQueries result;
        String key = moduleName.value + "_" + numId.value;
        SimpleCache<String, ModuleDNSQueries> simpleCache = this.moduleMap;
        synchronized (simpleCache) {
            result = this.moduleMap.get(key);
            if (result == null) {
                result = new ModuleDNSQueries(moduleName, numId);
                result.initialise(appContext);
                this.moduleMap.put(key, result);
                log.trace("Cached a new set of ModuleDNSQueries.");
            } else {
                log.trace("Using cached ModuleDNSQueries.");
            }
        }
        return result;
    }
}

