/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import lombok.NonNull;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.util.BaseLookupGenerator;
import uk.num.numlib.internal.util.HashUtils;
import uk.num.numlib.internal.util.LookupGenerator;

public final class EmailLookupGenerator
extends BaseLookupGenerator
implements LookupGenerator {
    public final String localPart;

    public EmailLookupGenerator(AppContext appContext, @NonNull String numId) {
        super(appContext, numId);
        if (numId == null) {
            throw new NullPointerException("numId is marked @NonNull but is null");
        }
        int atIndex = numId.indexOf(64);
        this.localPart = numId.substring(0, atIndex);
        int slashIndex = numId.indexOf("/");
        if (slashIndex > -1) {
            this.domain = EmailLookupGenerator.normaliseDomainName(numId.substring(atIndex + 1, slashIndex));
            this.branch = this.transformBranch(numId.substring(slashIndex));
        } else {
            this.domain = EmailLookupGenerator.normaliseDomainName(numId.substring(atIndex + 1));
        }
    }

    @Override
    public String getIndependentLocation(String moduleId) {
        String result = this.getRootIndependentLocation(moduleId);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    @Override
    public String getHostedLocation(String moduleId) {
        String result = this.getRootHostedLocation(moduleId);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    @Override
    public String getPopulatorLocation(String moduleId) {
        return null;
    }

    @Override
    public String getRootIndependentLocation(String moduleId) {
        return moduleId + "." + this.appContext.stringConstants.DOMAIN_NAME_PREFIX() + this.localPart + "." + this.appContext.stringConstants.EMAIL_DOMAIN_SEPARATOR() + this.appContext.stringConstants.UTILITY_MODULE_PREFIX() + this.domain + ".";
    }

    @Override
    public String getRootHostedLocation(String moduleId) {
        return moduleId + "." + this.appContext.stringConstants.DOMAIN_NAME_PREFIX() + this.localPart + "." + this.appContext.stringConstants.EMAIL_DOMAIN_SEPARATOR() + "." + this.appContext.stringConstants.DOMAIN_NAME_PREFIX() + this.domain + HashUtils.hash3(this.domain) + this.appContext.stringConstants.HOSTED_RECORD_SUFFIX() + ".";
    }

    public String getDistributedIndependentLocation(String moduleId, int levels) {
        String emailLocalPartHash = HashUtils.hash(this.localPart, levels);
        String result = moduleId + "." + this.appContext.stringConstants.DOMAIN_NAME_PREFIX() + this.localPart + emailLocalPartHash + "." + this.appContext.stringConstants.EMAIL_DOMAIN_SEPARATOR() + this.appContext.stringConstants.UTILITY_MODULE_PREFIX() + this.domain + ".";
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    public String getDistributedHostedLocation(String moduleId, int levels) {
        String emailLocalPartHash = HashUtils.hash(this.localPart, levels);
        String result = moduleId + "." + this.appContext.stringConstants.DOMAIN_NAME_PREFIX() + this.localPart + emailLocalPartHash + "." + this.appContext.stringConstants.EMAIL_DOMAIN_SEPARATOR() + "." + this.appContext.stringConstants.DOMAIN_NAME_PREFIX() + this.domain + HashUtils.hash3(this.domain) + this.appContext.stringConstants.HOSTED_RECORD_SUFFIX() + ".";
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }
}

