/*
 * Decompiled with CFR 0.152.
 */
package uk.num.tnum.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.util.BaseLookupGenerator;
import uk.num.numlib.util.LookupGenerator;
import uk.num.numlib.util.StringConstants;
import uk.num.tnum.util.CountryCode;
import uk.num.tnum.util.MappingPattern;
import uk.num.tnum.validators.NumTNumValidator;
import uk.num.validators.ValidationResult;

public class TNumLookupGenerator
extends BaseLookupGenerator {
    private static final Logger log = LogManager.getLogger(TNumLookupGenerator.class);
    private static final String NO_COUNTRY_CODE_MSG = "No Country code defined for ";
    private static final String INVALID_PARAM_MSG = "Module number should be >= 0";
    private static final List<CountryCode> codes = Arrays.asList(new CountryCode("+1", MappingPattern.BDS, "44.tnum.net"), new CountryCode("+44", MappingPattern.BDS, "44.tnum.net"), new CountryCode("+9999", MappingPattern.SDS, "9.9.9.9.e164.arpa"));
    public static final Comparator<CountryCode> byInternationalDiallingCodeDescending = (countryCode1, countryCode2) -> {
        int code2Len;
        String diallingCode1 = countryCode1.getCode();
        String diallingCode2 = countryCode2.getCode();
        int code1Len = diallingCode1.length();
        if (code1Len == (code2Len = diallingCode2.length())) {
            return diallingCode2.compareTo(diallingCode1);
        }
        if (code1Len == code2Len) {
            return 0;
        }
        if (code1Len > code2Len) {
            return -1;
        }
        return 1;
    };

    public TNumLookupGenerator(@NonNull String numId) {
        super(numId);
        if (numId == null) {
            throw new NullPointerException("numId is marked non-null but is null");
        }
        LookupGenerator.NumUriComponents components = TNumLookupGenerator.parseNumUriString((String)numId);
        this.domain = TNumLookupGenerator.normaliseDomainName((String)components.getDomain());
        this.branch = components.getPath();
        this.branch = this.branch.equals("/") || this.branch.equals("") ? null : this.transformBranch(TNumLookupGenerator.normalisePath((String)this.branch));
    }

    public String getPopulatorLocation(int moduleNumber) throws NumInvalidParameterException {
        throw new NumInvalidParameterException("Populator queries are not suppported.");
    }

    public String getIndependentLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException(INVALID_PARAM_MSG + moduleNumber);
        }
        ValidationResult validationResult = NumTNumValidator.validate(this.domain);
        if (validationResult != ValidationResult.VALID_NO_ERRORS) {
            throw new NumInvalidParameterException(validationResult.toString());
        }
        String result = this.getRootIndependentLocation(moduleNumber);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    public String getHostedLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException(INVALID_PARAM_MSG + moduleNumber);
        }
        ValidationResult validationResult = NumTNumValidator.validate(this.domain);
        if (validationResult != ValidationResult.VALID_NO_ERRORS) {
            throw new NumInvalidParameterException(validationResult.toString());
        }
        String result = this.getRootHostedLocation(moduleNumber);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    public String getRootIndependentLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException(INVALID_PARAM_MSG + moduleNumber);
        }
        ValidationResult validationResult = NumTNumValidator.validate(this.domain);
        if (validationResult != ValidationResult.VALID_NO_ERRORS) {
            throw new NumInvalidParameterException(validationResult.toString());
        }
        CountryCode countryCode = this.findCountryCode(this.domain).orElseThrow(() -> new NumInvalidParameterException(NO_COUNTRY_CODE_MSG + this.domain));
        return moduleNumber + "._num." + this.formatIndependentTNumDomain(countryCode, this.domain) + "." + countryCode.getDnsRoot() + ".";
    }

    public String getRootHostedLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException(INVALID_PARAM_MSG + moduleNumber);
        }
        ValidationResult validationResult = NumTNumValidator.validate(this.domain);
        if (validationResult != ValidationResult.VALID_NO_ERRORS) {
            throw new NumInvalidParameterException(validationResult.toString());
        }
        CountryCode countryCode = this.findCountryCode(this.domain).orElseThrow(() -> new NumInvalidParameterException(NO_COUNTRY_CODE_MSG + this.domain));
        if (MappingPattern.SDS == countryCode.getMappingPattern()) {
            return moduleNumber + "." + "_" + this.formatHostedTNumDomain(countryCode, this.domain) + "." + countryCode.getDnsRoot() + ".";
        }
        return moduleNumber + "." + "_" + this.formatHostedTNumDomain(countryCode, this.domain) + "._t." + StringConstants.TOP_LEVEL_ZONE + ".";
    }

    public String getRootIndependentLocationNoModuleNumber(LookupGenerator.TrailingDot addTrailingDot) {
        try {
            CountryCode countryCode = this.findCountryCode(this.domain).orElseThrow(() -> new NumInvalidParameterException(NO_COUNTRY_CODE_MSG + this.domain));
            if (addTrailingDot == LookupGenerator.TrailingDot.ADD_TRAILING_DOT) {
                return "_num." + this.formatIndependentTNumDomain(countryCode, this.domain) + "." + countryCode.getDnsRoot() + ".";
            }
            return "_num." + this.formatIndependentTNumDomain(countryCode, this.domain) + "." + countryCode.getDnsRoot();
        }
        catch (Exception e) {
            log.error((Object)e);
            return this.domain;
        }
    }

    public String getRootHostedLocationNoModuleNumber(LookupGenerator.TrailingDot addTrailingDot) {
        try {
            if (addTrailingDot == LookupGenerator.TrailingDot.ADD_TRAILING_DOT) {
                return this.getRootHostedLocation(1).substring(2);
            }
            return StringUtils.removeEnd((String)this.getRootHostedLocation(1).substring(2), (String)".");
        }
        catch (Exception e) {
            log.error((Object)e);
            return this.domain;
        }
    }

    private String formatIndependentTNumDomain(@NonNull CountryCode code, @NonNull String domain) throws NumInvalidParameterException {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        String noIntlPrefix = domain.substring(code.getCode().length());
        String result = "";
        switch (code.getMappingPattern()) {
            case BDS: {
                result = this.mapBDS(noIntlPrefix);
                result = StringUtils.reverse((String)result);
                break;
            }
            case SDS: {
                result = this.mapSDS(noIntlPrefix);
                break;
            }
            default: {
                throw new NumInvalidParameterException("Bad enum value: " + (Object)((Object)code.getMappingPattern()));
            }
        }
        return result;
    }

    private String formatHostedTNumDomain(@NonNull CountryCode code, @NonNull String domain) throws NumInvalidParameterException {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        String noIntlPrefix = domain.substring(code.getCode().length());
        String result = "";
        switch (code.getMappingPattern()) {
            case BDS: {
                result = this.mapBDS(noIntlPrefix);
                result = StringUtils.reverse((String)result) + "." + StringUtils.reverse((String)code.getCode().substring(1));
                break;
            }
            case SDS: {
                result = this.mapSDS(noIntlPrefix);
                break;
            }
            default: {
                throw new NumInvalidParameterException("Bad enum value: " + (Object)((Object)code.getMappingPattern()));
            }
        }
        return result;
    }

    private String mapBDS(@NonNull String noIntlPrefix) {
        if (noIntlPrefix == null) {
            throw new NullPointerException("noIntlPrefix is marked non-null but is null");
        }
        StringBuilder result = new StringBuilder();
        int count = 0;
        int threes = 1;
        int insertions = 0;
        while (count < noIntlPrefix.length()) {
            result.append(noIntlPrefix.charAt(count));
            if (threes % 3 == 0 && insertions < 2) {
                result.append(".");
                ++insertions;
            }
            ++count;
            ++threes;
        }
        return result.toString();
    }

    private String mapSDS(@NonNull String noIntlPrefix) {
        if (noIntlPrefix == null) {
            throw new NullPointerException("noIntlPrefix is marked non-null but is null");
        }
        return this.intersperseDots(StringUtils.reverse((String)noIntlPrefix));
    }

    private String intersperseDots(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return Arrays.asList(s.split("")).stream().collect(Collectors.joining("."));
    }

    private Optional<CountryCode> findCountryCode(String domain) {
        return codes.stream().filter(c -> domain.startsWith(c.getCode())).findFirst();
    }

    static {
        codes.sort(byInternationalDiallingCodeDescending);
    }
}

