/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package uk.num.punycode;

import static uk.num.punycode.PunycodeFunctions.adapt;
import static uk.num.punycode.PunycodeFunctions.base;
import static uk.num.punycode.PunycodeFunctions.basicToDigit;
import static uk.num.punycode.PunycodeFunctions.delimiter;
import static uk.num.punycode.PunycodeFunctions.digitToBasic;
import static uk.num.punycode.PunycodeFunctions.error;
import static uk.num.punycode.PunycodeFunctions.initialBias;
import static uk.num.punycode.PunycodeFunctions.initialN;
import static uk.num.punycode.PunycodeFunctions.maxInt;
import static uk.num.punycode.PunycodeFunctions.tMax;
import static uk.num.punycode.PunycodeFunctions.tMin;

/**
 * An incomplete translation of https://github.com/mathiasbynens/punycode.js
 */
public class Punycode {

    public static String decode(final String input) {
        // Don't use UCS-2.
        final StringBuilder output = new StringBuilder();
        final int inputLength = input.length();
        int i = 0;
        int n = initialN;
        int bias = initialBias;

        // Handle the basic code points: let `basic` be the number of input code
        // points before the last delimiter, or `0` if there is none, then copy
        // the first basic code points to the output.

        int basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
            basic = 0;
        }

        for (int j = 0; j < basic; ++j) {
            // if it's not a basic code point
            if (input.charAt(j) >= 0x80) {
                error("not-basic");
            }
            output.append(input.charAt(j));
        }

        // Main decoding loop: start just after the last delimiter if any basic code
        // points were copied; start at the beginning otherwise.

        for (int index = basic > 0 ? basic + 1 : 0; index < inputLength; /* no final expression */) {

            // `index` is the index of the next character to be consumed.
            // Decode a generalized variable-length integer into `delta`,
            // which gets added to `i`. The overflow checking is easier
            // if we increase `i` as we go, then subtract off its starting
            // value at the end to obtain `delta`.
            final int oldi = i;
            for (int w = 1, k = base; /* no condition */ ; k += base) {

                if (index >= inputLength) {
                    error("invalid-input");
                }

                final int digit = basicToDigit(input.charAt(index++));

                if (digit >= base || digit > (maxInt - i) / w) {
                    error("overflow");
                }

                i += digit * w;
                final int t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);

                if (digit < t) {
                    break;
                }

                final int baseMinusT = base - t;
                if (w > (maxInt / baseMinusT)) {
                    error("overflow");
                }

                w *= baseMinusT;

            }

            final int out = output.length() + 1;
            bias = adapt(i - oldi, out, oldi == 0);

            // `i` was supposed to wrap around from `out` to `0`,
            // incrementing `n` each time, so we'll fix that now:
            if ((i / out) > maxInt - n) {
                error("overflow");
            }

            n += (i / out);
            i %= out;

            // Insert `n` at position `i` of the output.
            output.insert(i++, (char) n);

        }

        return output.toString();
    }

    public static String encode(final String input) {
        final StringBuilder output = new StringBuilder();

        // Cache the length.
        final int inputLength = input.length();

        // Initialize the state.
        int n = initialN;
        int delta = 0;
        int bias = initialBias;

        // Handle the basic code points.
        input.codePoints()
                .forEachOrdered(currentValue -> {
                    if (currentValue < 0x80) {
                        output.append((char) currentValue);
                    }
                });

        final int basicLength = output.length();
        int handledCPCount = basicLength;

        // `handledCPCount` is the number of code points that have been handled;
        // `basicLength` is the number of basic code points.

        // Finish the basic string with a delimiter unless it's empty.
        if (output.length() > 0) {
            output.append(delimiter);
        }

        // Main encoding loop:
        while (handledCPCount < inputLength) {

            // All non-basic code points < n have been handled already. Find the next
            // larger one:
            int m = maxInt;
            for (int x = 0; x < inputLength; x++) {
                final int currentValue = input.charAt(x);
                if (currentValue >= n && currentValue < m) {
                    m = currentValue;
                }
            }

            // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
            // but guard against overflow.
            final int handledCPCountPlusOne = handledCPCount + 1;
            if (m - n > ((maxInt - delta) / handledCPCountPlusOne)) {
                error("overflow");
            }

            delta += (m - n) * handledCPCountPlusOne;
            n = m;

            for (int x = 0; x < inputLength; x++) {
                final int currentValue = input.charAt(x);
                if (currentValue < n) {
                    ++delta;
                }

                if (currentValue == n) {
                    // Represent delta as a generalized variable-length integer.
                    int q = delta;
                    for (int k = base; /* no condition */ ; k += base) {
                        int t = (k <= bias) ? tMin : ((k >= bias + tMax) ? tMax : k - bias);
                        if (q < t) {
                            break;
                        }
                        int qMinusT = q - t;
                        int baseMinusT = base - t;
                        output.append((char) digitToBasic((char) (t + qMinusT % baseMinusT)));
                        q = (char) (qMinusT / baseMinusT);
                    }

                    output.append((char) digitToBasic(q));
                    bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
                    delta = 0;
                    ++handledCPCount;
                }
            }

            ++delta;
            ++n;

        }
        return output.toString();
    }

}
