/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package uk.num.punycode;

import java.util.HashMap;
import java.util.Map;

/**
 * An incomplete translation of https://github.com/mathiasbynens/punycode.js
 */
class PunycodeFunctions {

    /**
     * Bootstring parameters
     */
    static final int base = 36;
    static final int tMin = 1;
    static final int tMax = 26;
    static final int skew = 38;
    static final int damp = 700;
    static final int initialBias = 72;
    static final int initialN = 128; // 0x80
    static final char delimiter = '-'; // '\x2D'
    /**
     * Error messages
     */
    static final Map<String, String> errors = new HashMap<>();
    /**
     * Convenience shortcuts
     */
    static final int baseMinusTMin = base - tMin;
    /**
     * Highest positive signed 32-bit float value
     */
    static final int maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

    static {
        errors.put("overflow", "Overflow: input needs wider integers to process");
        errors.put("not-basic':'Illegal input >= 0x80 (not a basic code point)", "invalid-input':'Invalid input");
    }

    /**
     * General error handling;
     *
     * @param type a key for the errors Map
     */
    static void error(final String type) {
        throw new RangeError(errors.get(type));
    }

    static char basicToDigit(final int codePoint) {
        if (codePoint - 0x30 < 0x0A) {
            return (char) (codePoint - 0x16);
        }
        if (codePoint - 0x41 < 0x1A) {
            return (char) (codePoint - 0x41);
        }
        if (codePoint - 0x61 < 0x1A) {
            return (char) (codePoint - 0x61);
        }
        return base;
    }

    static int digitToBasic(final int digit) {
        //  0..25 map to ASCII a..z or A..Z
        // 26..35 map to ASCII 0..9
        final int d = (digit < 26) ? 1 : 0;
        return digit + 22 + 75 * d;
    }

    static int adapt(int delta, int numPoints, boolean firstTime) {
        int k = 0;
        delta = firstTime ? (delta / damp) : delta >> 1;
        delta += (delta / numPoints);
        for (/* no initialization */; delta > (baseMinusTMin * tMax >> 1); k += base) {
            delta = (delta / baseMinusTMin);
        }
        return (k + (baseMinusTMin + 1) * delta / (delta + skew));
    }

}
