/*
 * Decompiled with CFR 0.152.
 */
package uk.num.punycode;

import java.util.HashMap;
import java.util.Map;
import uk.num.punycode.RangeError;

class PunycodeFunctions {
    static final int base = 36;
    static final int tMin = 1;
    static final int tMax = 26;
    static final int skew = 38;
    static final int damp = 700;
    static final int initialBias = 72;
    static final int initialN = 128;
    static final char delimiter = '-';
    static final Map<String, String> errors = new HashMap<String, String>();
    static final int baseMinusTMin = 35;
    static final int maxInt = Integer.MAX_VALUE;

    PunycodeFunctions() {
    }

    static void error(String type) {
        throw new RangeError(errors.get(type));
    }

    static char basicToDigit(int codePoint) {
        if (codePoint - 48 < 10) {
            return (char)(codePoint - 22);
        }
        if (codePoint - 65 < 26) {
            return (char)(codePoint - 65);
        }
        if (codePoint - 97 < 26) {
            return (char)(codePoint - 97);
        }
        return '$';
    }

    static int digitToBasic(int digit) {
        int d = digit < 26 ? 1 : 0;
        return digit + 22 + 75 * d;
    }

    static int adapt(int delta, int numPoints, boolean firstTime) {
        int k = 0;
        delta = firstTime ? delta / 700 : delta >> 1;
        delta += delta / numPoints;
        while (delta > 455) {
            delta /= 35;
            k += 36;
        }
        return k + 36 * delta / (delta + 38);
    }

    static {
        errors.put("overflow", "Overflow: input needs wider integers to process");
        errors.put("not-basic':'Illegal input >= 0x80 (not a basic code point)", "invalid-input':'Invalid input");
    }
}

