/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.Parameter;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.java.type.Type;
import org.codehaus.xfire.java.wsdl.WSDLBuilder;
import org.codehaus.xfire.service.SimpleService;
import org.codehaus.xfire.transport.Session;
import org.codehaus.xfire.wsdl.WSDLWriter;

public class DefaultJavaService
extends SimpleService
implements JavaService {
    private TypeMappingRegistry typeMappingRegistry;
    private TypeMapping typeMapping;
    private List allowedMethods = new ArrayList();
    private Class serviceClass;
    private Hashtable operations = new Hashtable();
    private WSDLBuilder wsdlBuilder;
    private boolean autoTyped = false;
    private int scope = 1;
    private Object appObj;

    public DefaultJavaService() {
    }

    public DefaultJavaService(TypeMappingRegistry registry) {
        this.typeMappingRegistry = registry;
    }

    public void setServiceClass(String className) throws ClassNotFoundException {
        this.setServiceClass(this.loadClass(className));
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void initializeOperations() {
        Method[] methods = this.serviceClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            int modifiers = method.getModifiers();
            if (!this.isAllowed(methodName) || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            this.addOperation(method);
        }
    }

    protected void addOperation(Method method) {
        Operation op = new Operation(method, this);
        this.operations.put(method.getName(), op);
        Class<?>[] paramClasses = method.getParameterTypes();
        boolean isDoc = this.getStyle().equals("document");
        for (int j = 0; j < paramClasses.length; ++j) {
            String paramName = "";
            if (isDoc) {
                paramName = method.getName();
            }
            paramName = paramName + "in" + j;
            String ns = this.getDefaultNamespace();
            Type t = this.getTypeMapping().getType(paramClasses[j]);
            if (t.isComplex()) {
                ns = t.getSchemaType().getNamespaceURI();
            }
            QName q = new QName(ns, paramName);
            Parameter p = new Parameter(q, t);
            op.addParameter(p);
        }
        String outName = "";
        if (isDoc) {
            outName = method.getName();
        }
        String ns = this.getDefaultNamespace();
        Type t = this.getTypeMapping().getType(method.getReturnType());
        if (t.isComplex()) {
            ns = t.getSchemaType().getNamespaceURI();
        }
        QName q = new QName(ns, outName + "out");
        Parameter outP = new Parameter(q, t);
        op.setOutParameter(outP);
    }

    private boolean isAllowed(String methodName) {
        return this.allowedMethods.size() == 0 || this.allowedMethods.contains(methodName);
    }

    public Operation getOperation(String localName, String namespace) {
        return (Operation)this.operations.get(localName);
    }

    public Collection getOperations() {
        return this.operations.values();
    }

    protected Map getOperationsMap() {
        return this.operations;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException cnf2) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
    }

    public void initializeTypeMapping() {
        TypeMapping tm = null;
        if (this.getUse() != null) {
            tm = this.getUse().equals("encoded") ? this.getTypeMappingRegistry().createTypeMapping(this.getSoapVersion().getSoapEncodingStyle(), this.autoTyped) : this.getTypeMappingRegistry().createTypeMapping("http://www.w3.org/2001/XMLSchema", this.autoTyped);
            this.setTypeMapping(tm);
            this.getTypeMappingRegistry().register(this.getDefaultNamespace(), tm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getServiceObject(MessageContext context) throws XFireFault {
        if (this.scope == 1) {
            if (this.appObj == null) {
                Class clazz = DefaultJavaService.class;
                synchronized (clazz) {
                    this.appObj = this.createServiceObject();
                }
            }
            return this.appObj;
        }
        if (this.scope == 2) {
            String key;
            Session session = context.getSession();
            Object sessObj = session.get((Object)(key = "service." + this.getName()));
            if (sessObj == null) {
                Class clazz = DefaultJavaService.class;
                synchronized (clazz) {
                    sessObj = this.createServiceObject();
                    session.put((Object)key, sessObj);
                }
            }
            return sessObj;
        }
        if (this.scope == 3) {
            return this.createServiceObject();
        }
        throw new UnsupportedOperationException("Scope " + this.scope + " is invalid.");
    }

    public Object createServiceObject() throws XFireFault {
        try {
            return this.getServiceClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new XFireFault("Couldn't instantiate service object.", (Throwable)e, "Receiver");
        }
        catch (IllegalAccessException e) {
            throw new XFireFault("Couldn't access service object.", (Throwable)e, "Receiver");
        }
    }

    public WSDLWriter getWSDLWriter() throws WSDLException {
        WSDLBuilder b;
        WSDLWriter writer = super.getWSDLWriter();
        if (writer == null && (b = this.getWSDLBuilder()) != null) {
            return this.getWSDLBuilder().createWSDLWriter(this);
        }
        return writer;
    }

    public boolean isAutoTyped() {
        return this.autoTyped;
    }

    public void setAutoTyped(boolean autoTyped) {
        this.autoTyped = autoTyped;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public WSDLBuilder getWSDLBuilder() {
        return this.wsdlBuilder;
    }

    public void setWSDLBuilder(WSDLBuilder wsdlBuilder) {
        this.wsdlBuilder = wsdlBuilder;
    }
}

