/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.lambdainvoker;

import android.util.Log;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaDataBinder;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaFunction;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaFunctionException;
import com.amazonaws.mobileconnectors.util.ClientContext;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.InvocationType;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.LogType;
import com.amazonaws.util.Base64;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

class LambdaInvocationHandler
implements InvocationHandler {
    private static final String TAG = "LambdaInvocationHandler";
    private final AWSLambda lambda;
    private final LambdaDataBinder binder;
    private final ClientContext clientContext;

    public LambdaInvocationHandler(AWSLambda lambda, LambdaDataBinder binder, ClientContext clientContext) {
        this.lambda = lambda;
        this.binder = binder;
        this.clientContext = clientContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.validateInterfaceMethod(method, args);
        InvokeRequest invokeRequest = this.buildInvokeRequest(method, args == null ? null : args[0]);
        InvokeResult invokeResult = this.lambda.invoke(invokeRequest);
        return this.processInvokeResult(method, invokeResult);
    }

    void validateInterfaceMethod(Method method, Object[] args) {
        if (method.getAnnotation(LambdaFunction.class) == null) {
            throw new UnsupportedOperationException("No LambdaFunction annotation for method " + method.getName());
        }
        if (args != null && args.length > 1) {
            throw new UnsupportedOperationException("LambdaFunctions take either 0 or 1 arguments.");
        }
    }

    InvokeRequest buildInvokeRequest(Method method, Object object) throws IOException {
        LambdaFunction lambdaFunction = method.getAnnotation(LambdaFunction.class);
        InvokeRequest invokeRequest = new InvokeRequest();
        if (lambdaFunction.functionName().isEmpty()) {
            invokeRequest.setFunctionName(method.getName());
        } else {
            invokeRequest.setFunctionName(lambdaFunction.functionName());
        }
        invokeRequest.setLogType(lambdaFunction.logType());
        if (!LogType.None.equals(lambdaFunction.logType())) {
            invokeRequest.setInvocationType(InvocationType.RequestResponse);
        } else {
            invokeRequest.setInvocationType(lambdaFunction.invocationType());
        }
        if (this.clientContext != null) {
            invokeRequest.setClientContext(this.clientContext.toBase64String());
        }
        invokeRequest.setPayload(ByteBuffer.wrap(this.binder.serialize(object)));
        return invokeRequest;
    }

    Object processInvokeResult(Method method, InvokeResult invokeResult) throws IOException {
        if (invokeResult.getLogResult() != null) {
            Log.d((String)TAG, (String)(method.getName() + " log: " + new String(Base64.decode((String)invokeResult.getLogResult()))));
        }
        if (invokeResult.getFunctionError() != null) {
            throw new LambdaFunctionException(invokeResult.getFunctionError(), new String(invokeResult.getPayload().array()));
        }
        if (invokeResult.getStatusCode() == 204 || method.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        return this.binder.deserialize(invokeResult.getPayload().array(), method.getReturnType());
    }
}

