/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.lambdainvoker;

import android.content.Context;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaDataBinder;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaInvocationHandler;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaJsonBinder;
import com.amazonaws.mobileconnectors.util.ClientContext;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClient;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class LambdaInvokerFactory {
    private final AWSLambda lambda;
    private final ClientContext clientContext;

    public LambdaInvokerFactory(Context context, Regions region, AWSCredentialsProvider provider) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider can't be null");
        }
        this.lambda = new AWSLambdaClient(provider);
        this.lambda.setRegion(Region.getRegion((Regions)region));
        this.clientContext = new ClientContext(context);
    }

    LambdaInvokerFactory(AWSLambda lambda, ClientContext clientContext) {
        this.lambda = lambda;
        this.clientContext = clientContext;
    }

    public <T> T build(Class<T> interfaceClass) {
        return this.build(interfaceClass, new LambdaJsonBinder());
    }

    public <T> T build(Class<T> interfaceClass, LambdaDataBinder binder) {
        Object proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new LambdaInvocationHandler(this.lambda, binder, this.clientContext));
        return interfaceClass.cast(proxy);
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }
}

