/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.C2jModels;
import com.amazonaws.codegen.IntermediateModelBuilder;
import com.amazonaws.codegen.emitters.CodeEmitter;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskExecutor;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.ApiGatewayGeneratorTasks;
import com.amazonaws.codegen.emitters.tasks.AwsGeneratorTasks;
import com.amazonaws.codegen.internal.Jackson;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.Protocol;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class CodeGenerator {
    private static final String MODEL_DIR_NAME = "models";
    private final C2jModels models;
    private final String outputDirectory;
    private final String codeGenBinDirectory;
    private final String fileNamePrefix;

    public CodeGenerator(C2jModels models, String outputDirectory, String codeGenBinDirectory, String fileNamePrefix) {
        this.models = models;
        this.outputDirectory = outputDirectory;
        this.codeGenBinDirectory = codeGenBinDirectory;
        this.fileNamePrefix = fileNamePrefix;
    }

    public void execute() {
        try {
            IntermediateModel intermediateModel = new IntermediateModelBuilder(this.models, this.codeGenBinDirectory).build();
            this.writeIntermediateModel(intermediateModel);
            this.emitCode(intermediateModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate code. Exception message : " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIntermediateModel(IntermediateModel model) throws IOException {
        File modelDir = CodeGenerator.getModelDirectory(this.outputDirectory);
        PrintWriter writer = null;
        try {
            File outDir = new File(this.outputDirectory);
            if (!outDir.exists() && !outDir.mkdirs()) {
                throw new RuntimeException("Failed to create " + outDir.getAbsolutePath());
            }
            File outputFile = new File(modelDir, this.fileNamePrefix + "-intermediate.json");
            if (!outputFile.exists() && !outputFile.createNewFile()) {
                throw new RuntimeException("Error creating file " + outputFile.getAbsolutePath());
            }
            writer = new PrintWriter(outputFile, "UTF-8");
            Jackson.write(model, writer);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    private void emitCode(IntermediateModel intermediateModel) throws Exception {
        Iterable<GeneratorTask> generatorTasks = this.createGeneratorTasks(intermediateModel);
        try (CodeEmitter emitter = new CodeEmitter(generatorTasks, new GeneratorTaskExecutor());){
            emitter.emit();
        }
    }

    private Iterable<GeneratorTask> createGeneratorTasks(IntermediateModel intermediateModel) {
        GeneratorTaskParams params = GeneratorTaskParams.create(intermediateModel, this.outputDirectory, this.outputDirectory);
        if (params.getModel().getMetadata().getProtocol() == Protocol.API_GATEWAY) {
            return new ApiGatewayGeneratorTasks(params);
        }
        return new AwsGeneratorTasks(params);
    }

    public static File getModelDirectory(String outputDirectory) {
        File dir = new File(outputDirectory, MODEL_DIR_NAME);
        Utils.createDirectory(dir);
        return dir;
    }
}

