/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.AddShapes;
import com.amazonaws.codegen.IntermediateModelBuilder;
import com.amazonaws.codegen.IntermediateModelShapeProcessor;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.model.service.ErrorMap;
import com.amazonaws.codegen.model.service.ErrorTrait;
import com.amazonaws.codegen.model.service.Operation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class AddExceptionShapes
extends AddShapes
implements IntermediateModelShapeProcessor {
    AddExceptionShapes(IntermediateModelBuilder builder) {
        super(builder);
    }

    @Override
    public Map<String, ShapeModel> process(Map<String, OperationModel> currentOperations, Map<String, ShapeModel> currentShapes) {
        return this.constructExceptionShapes();
    }

    private Map<String, ShapeModel> constructExceptionShapes() {
        HashMap<String, ShapeModel> javaShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Operation> entry : this.getServiceModel().getOperations().entrySet()) {
            Operation operation = entry.getValue();
            List<ErrorMap> operationErrors = operation.getErrors();
            if (operationErrors == null) continue;
            for (ErrorMap error : operationErrors) {
                String errorShapeName = error.getShape();
                String javaClassName = this.getNamingStrategy().getExceptionName(errorShapeName);
                ShapeModel exceptionShapeModel = this.generateShapeModel(javaClassName, errorShapeName);
                exceptionShapeModel.setType(ShapeType.Exception.getValue());
                exceptionShapeModel.setErrorCode(this.getErrorCode(errorShapeName));
                if (exceptionShapeModel.getDocumentation() == null) {
                    exceptionShapeModel.setDocumentation(error.getDocumentation());
                }
                javaShapes.put(javaClassName, exceptionShapeModel);
            }
        }
        return javaShapes;
    }

    private String getErrorCode(String errorShapeName) {
        ErrorTrait errorTrait = this.getServiceModel().getShapes().get(errorShapeName).getErrorTrait();
        if (this.isErrorCodeOverridden(errorTrait)) {
            return errorTrait.getErrorCode();
        }
        return errorShapeName;
    }

    private boolean isErrorCodeOverridden(ErrorTrait errorTrait) {
        return errorTrait != null && !Utils.isNullOrEmpty(errorTrait.getErrorCode());
    }
}

