/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.ant.task;

import com.amazonaws.codegen.IntermediateModelBuilder;
import com.amazonaws.codegen.ant.task.CodeGeneratorTask;
import com.amazonaws.codegen.emitters.CodeEmitter;
import com.amazonaws.codegen.internal.Jackson;
import com.amazonaws.codegen.model.config.BasicCodeGenConfig;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.ServiceExamples;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Waiters;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ExecutionException;

public class CodeGenerator {
    private final ServiceModel serviceModel;
    private final ServiceExamples serviceExamples;
    private final BasicCodeGenConfig codeGenConfig;
    private final CustomizationConfig customConfig;
    private final String outputDirectory;
    private final String fileNamePrefix;
    private final Waiters waiters;

    public CodeGenerator(ServiceModel serviceModel, ServiceExamples serviceExamples, BasicCodeGenConfig codeGenConfig, CustomizationConfig customConfig, String outputDirectory, String fileNamePrefix, Waiters waiters) {
        this.serviceModel = serviceModel;
        this.serviceExamples = serviceExamples;
        this.codeGenConfig = codeGenConfig;
        this.customConfig = customConfig;
        this.outputDirectory = outputDirectory;
        this.fileNamePrefix = fileNamePrefix;
        this.waiters = waiters;
    }

    public void execute() {
        try {
            IntermediateModel intermediateModel = new IntermediateModelBuilder(this.customConfig, this.codeGenConfig, this.serviceModel, this.serviceExamples, this.waiters).build();
            this.writeIntermediateModel(intermediateModel);
            this.emitCode(intermediateModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate code. Exception message : " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIntermediateModel(IntermediateModel model) throws IOException {
        File modelDir = CodeGeneratorTask.getModelDirectory(this.outputDirectory);
        PrintWriter writer = null;
        try {
            File outDir = new File(this.outputDirectory);
            if (!outDir.exists() && !outDir.mkdirs()) {
                throw new RuntimeException("Failed to create " + outDir.getAbsolutePath());
            }
            File outputFile = new File(modelDir, this.fileNamePrefix + "-intermediate.json");
            if (!outputFile.exists() && !outputFile.createNewFile()) {
                throw new RuntimeException("Error creating file " + outputFile.getAbsolutePath());
            }
            writer = new PrintWriter(outputFile, "UTF-8");
            Jackson.write(model, writer);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    private void emitCode(IntermediateModel intermediateModel) throws JsonGenerationException, JsonMappingException, IOException, InterruptedException, ExecutionException {
        try (CodeEmitter emitter = new CodeEmitter(intermediateModel, this.outputDirectory);){
            emitter.emit();
        }
    }
}

