/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import com.amazonaws.codegen.internal.ImmutableMapParameter;
import com.amazonaws.codegen.model.intermediate.Metadata;
import java.util.ArrayList;
import java.util.List;

public class EndpointDiscoveryGeneratorTasks
extends BaseGeneratorTasks {
    private final String endpointDiscoveryDir;

    public EndpointDiscoveryGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.endpointDiscoveryDir = dependencies.getPathProvider().getEndpointDiscoveryDirectory();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        ArrayList<GeneratorTask> generatorTasks = new ArrayList<GeneratorTask>();
        if (this.model.getEndpointOperation() != null) {
            String cacheName = this.model.getMetadata().getSyncInterface() + "EndpointCache";
            String cacheLoaderName = this.model.getMetadata().getSyncInterface() + "EndpointCacheLoader";
            ImmutableMapParameter<String, Metadata> cachedataModel = ImmutableMapParameter.of("fileHeader", this.model.getFileHeader(), "className", cacheName, "endpointOperation", this.model.getEndpointOperation(), "metadata", this.model.getMetadata());
            ImmutableMapParameter<String, Metadata> loaderDataModel = ImmutableMapParameter.of("fileHeader", this.model.getFileHeader(), "className", cacheLoaderName, "endpointOperation", this.model.getEndpointOperation(), "metadata", this.model.getMetadata());
            generatorTasks.add(new FreemarkerGeneratorTask(this.endpointDiscoveryDir, cacheName, this.freemarker.getEndpointDiscoveryCacheTemplate(), cachedataModel));
            generatorTasks.add(new FreemarkerGeneratorTask(this.endpointDiscoveryDir, cacheLoaderName, this.freemarker.getEndpointDiscoveryCacheLoaderTemplate(), loaderDataModel));
        }
        return generatorTasks;
    }
}

