/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.config.customization.ShapeModifier;
import com.amazonaws.codegen.model.config.customization.ShapeModifier_ModifyModel;
import com.amazonaws.codegen.model.config.customization.ShapeSubstitution;
import com.amazonaws.codegen.model.intermediate.Example;
import com.amazonaws.codegen.model.intermediate.ServiceExamples;
import com.amazonaws.codegen.model.service.Input;
import com.amazonaws.codegen.model.service.Member;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.Output;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExamplesCustomizer {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ServiceModel serviceModel;
    private final CustomizationConfig customizationConfig;

    public ExamplesCustomizer(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        this.serviceModel = serviceModel;
        this.customizationConfig = customizationConfig;
    }

    public ServiceExamples applyCustomizationsToExamples(ServiceExamples serviceExamples) {
        if (this.customizationConfig == null) {
            return serviceExamples;
        }
        serviceExamples.getOperationExamples().entrySet().forEach(e -> {
            String operationName = (String)e.getKey();
            Operation operation = this.serviceModel.getOperation(operationName);
            ((List)e.getValue()).forEach(example -> this.applyCustomizationsToExample((Example)example, operation));
        });
        return serviceExamples;
    }

    private Example applyCustomizationsToExample(Example example, Operation operation) {
        Output output;
        if (example == null) {
            return null;
        }
        System.out.println(String.format("Customizing operation example : %s", example.getId()));
        Input input = operation.getInput();
        if (input != null) {
            String inputShapeName = input.getShape();
            Shape inputShape = this.serviceModel.getShape(inputShapeName);
            JsonNode inputValue = example.getInput();
            example.setInput(this.applyCustomizationsToShapeJson(inputShapeName, inputShape, inputValue));
        }
        if ((output = operation.getOutput()) != null) {
            String outputShapeName = output.getShape();
            Shape outputShape = this.serviceModel.getShape(outputShapeName);
            JsonNode outputValue = example.getOutput();
            example.setOutput(this.applyCustomizationsToShapeJson(outputShapeName, outputShape, outputValue));
        }
        return example;
    }

    private JsonNode applyCustomizationsToShapeJson(String shapeName, Shape shape, JsonNode valueNode) {
        if (valueNode == null || !valueNode.isContainerNode()) {
            return valueNode;
        }
        valueNode = this.applyModificationsToShapeJson(shapeName, valueNode);
        ShapeSubstitution shapeSub = null;
        if (this.customizationConfig.getShapeSubstitutions() != null) {
            shapeSub = this.customizationConfig.getShapeSubstitutions().get(shapeName);
        }
        if (shapeSub != null) {
            String substituteShapeName = shapeSub.getEmitAsShape();
            Shape substituteShape = this.serviceModel.getShape(substituteShapeName);
            JsonNode substituteValue = valueNode;
            if (shapeSub.getEmitFromMember() != null && (substituteValue = valueNode.get(shapeSub.getEmitFromMember())) == null) {
                System.err.println(String.format("Warning: Substituting shape '%s' for its member '%s' as shape '%s' produced null value. Original value: %s", shapeName, shapeSub.getEmitFromMember(), substituteShapeName, valueNode.toString()));
            }
            System.out.println(String.format("Substituting shape %s with %s. %s -> %s", shapeName, substituteShapeName, valueNode.toString(), Objects.toString(substituteValue)));
            return this.applyCustomizationsToShapeJson(substituteShapeName, substituteShape, substituteValue);
        }
        switch (shape.getType()) {
            case "map": 
            case "structure": {
                if (shape.getMembers() == null) {
                    return valueNode;
                }
                ObjectNode obj = MAPPER.createObjectNode();
                for (Map.Entry<String, Member> e : shape.getMembers().entrySet()) {
                    Member member = e.getValue();
                    String memberName = e.getKey();
                    String memberShapeName = member.getShape();
                    Shape memberShape = this.serviceModel.getShape(memberShapeName);
                    JsonNode memberValue = valueNode.get(memberName);
                    if (memberValue == null) continue;
                    obj.set(memberName, this.applyCustomizationsToShapeJson(memberShapeName, memberShape, memberValue));
                }
                return obj;
            }
            case "list": {
                ArrayNode list = MAPPER.createArrayNode();
                String memberShapeName = shape.getListMember().getShape();
                Shape memberShape = this.serviceModel.getShape(memberShapeName);
                for (JsonNode e : valueNode) {
                    list.add(this.applyCustomizationsToShapeJson(memberShapeName, memberShape, e));
                }
                return list;
            }
        }
        throw new RuntimeException("Unknown shape type: " + shape.getType());
    }

    private JsonNode applyModificationsToShapeJson(String shapeName, JsonNode valueNode) {
        if (this.customizationConfig.getShapeModifiers() == null) {
            return valueNode;
        }
        ShapeModifier allShapeMode = this.customizationConfig.getShapeModifiers().get("*");
        ShapeModifier shapeMod = this.customizationConfig.getShapeModifiers().get(shapeName);
        valueNode = this.applyShapeModifier(valueNode, allShapeMode);
        valueNode = this.applyShapeModifier(valueNode, shapeMod);
        return valueNode;
    }

    private JsonNode applyShapeModifier(JsonNode node, ShapeModifier modifier) {
        if (node == null || modifier == null) {
            return node;
        }
        if (modifier.getExclude() == null && modifier.getModify() == null) {
            return node;
        }
        if (!node.isObject()) {
            return node;
        }
        ObjectNode obj = (ObjectNode)node;
        ObjectNode modified = MAPPER.createObjectNode();
        List<Object> excludes = modifier.getExclude() != null ? modifier.getExclude() : Collections.emptyList();
        obj.fieldNames().forEachRemaining(m -> {
            if (!excludes.contains(m)) {
                modified.set(m, obj.get(m));
            }
        });
        List<Object> modify = modifier.getModify() != null ? modifier.getModify() : Collections.emptyList();
        modify.forEach(memberMods -> memberMods.entrySet().forEach(memberMod -> {
            String memberName = (String)memberMod.getKey();
            ShapeModifier_ModifyModel modelModify = (ShapeModifier_ModifyModel)memberMod.getValue();
            if (modelModify.getEmitPropertyName() != null) {
                String newName = modelModify.getEmitPropertyName();
                modified.set(newName, modified.get(memberName));
                modified.remove(memberName);
                memberName = newName;
            }
        }));
        return modified;
    }
}

