/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.service.ErrorMap;
import com.amazonaws.codegen.model.service.Input;
import com.amazonaws.codegen.model.service.Member;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.Output;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import java.util.Map;

public class RenameShapesProcessor
implements CodegenCustomizationProcessor {
    private final Map<String, String> renameShapes;

    public RenameShapesProcessor(Map<String, String> renameShapes) {
        this.renameShapes = renameShapes;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        String newName;
        String originalName;
        if (this.renameShapes == null || this.renameShapes.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : this.renameShapes.entrySet()) {
            originalName = entry.getKey();
            newName = entry.getValue();
            Shape originalShape = serviceModel.getShapes().get(originalName);
            if (originalShape == null) {
                throw new IllegalStateException(String.format("Cannot find shape [%s] in the model when processing customization config renameShapes.%s", originalName, originalName));
            }
            if (!serviceModel.getShapes().containsKey(newName)) continue;
            throw new IllegalStateException(String.format("The shape [%s] for the new name is already in the model when processing customization config renameShapes.%s", newName, originalName));
        }
        for (Map.Entry<String, Object> entry : serviceModel.getShapes().entrySet()) {
            String shapeName = entry.getKey();
            Shape shape = (Shape)entry.getValue();
            this.preprocess_RenameMemberShapes(shapeName, shape);
        }
        for (Operation operation : serviceModel.getOperations().values()) {
            if (operation.getInput() != null) {
                this.preprocess_RenameInputShape(operation.getInput());
            }
            if (operation.getOutput() != null) {
                this.preprocess_RenameOutputShape(operation.getOutput());
            }
            if (operation.getErrors() == null) continue;
            for (ErrorMap error : operation.getErrors()) {
                this.preprocess_RenameErrorShape(error);
            }
        }
        for (Map.Entry entry : this.renameShapes.entrySet()) {
            originalName = (String)entry.getKey();
            newName = (String)entry.getValue();
            Shape shape = serviceModel.getShapes().remove(originalName);
            serviceModel.getShapes().put(newName, shape);
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }

    private void preprocess_RenameMemberShapes(String shapeName, Shape shape) {
        if (shape.getListMember() != null) {
            this.preprocess_RenameMemberShape(shape.getListMember());
        }
        if (shape.getMapKeyType() != null) {
            this.preprocess_RenameMemberShape(shape.getMapKeyType());
        }
        if (shape.getMapValueType() != null) {
            this.preprocess_RenameMemberShape(shape.getMapValueType());
        }
        if (shape.getMembers() != null) {
            for (Map.Entry<String, Member> entry : shape.getMembers().entrySet()) {
                this.preprocess_RenameMemberShape(entry.getValue());
            }
        }
    }

    private void preprocess_RenameMemberShape(Member member) {
        if (this.renameShapes.containsKey(member.getShape())) {
            member.setShape(this.renameShapes.get(member.getShape()));
        }
    }

    private void preprocess_RenameErrorShape(ErrorMap error) {
        if (this.renameShapes.containsKey(error.getShape())) {
            error.setShape(this.renameShapes.get(error.getShape()));
        }
    }

    private void preprocess_RenameOutputShape(Output output) {
        if (this.renameShapes.containsKey(output.getShape())) {
            output.setShape(this.renameShapes.get(output.getShape()));
        }
    }

    private void preprocess_RenameInputShape(Input input) {
        if (this.renameShapes.containsKey(input.getShape())) {
            input.setShape(this.renameShapes.get(input.getShape()));
        }
    }
}

