/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.AddShapes;
import com.amazonaws.codegen.IntermediateModelBuilder;
import com.amazonaws.codegen.IntermediateModelShapeProcessor;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.model.intermediate.ShapeUnmarshaller;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.Output;
import com.amazonaws.codegen.model.service.Shape;
import java.util.HashMap;
import java.util.Map;

final class AddOutputShapes
extends AddShapes
implements IntermediateModelShapeProcessor {
    AddOutputShapes(IntermediateModelBuilder builder) {
        super(builder);
    }

    @Override
    public Map<String, ShapeModel> process(Map<String, OperationModel> currentOperations, Map<String, ShapeModel> currentShapes) {
        return this.constructOutputShapes();
    }

    private Map<String, ShapeModel> constructOutputShapes() {
        Map<String, Operation> operations = this.getServiceModel().getOperations();
        Map<String, Shape> c2jShapes = this.getServiceModel().getShapes();
        HashMap<String, ShapeModel> javaShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Operation> entry : operations.entrySet()) {
            String operationName = entry.getKey();
            Operation operation = entry.getValue();
            Output output = operation.getOutput();
            if (output == null) continue;
            String javaResponseClassName = this.getNamingStrategy().getResponseClassName(operationName);
            ShapeModel outputShape = this.generateOutputShapeModel(operation, javaResponseClassName, c2jShapes);
            if (outputShape.getDocumentation() == null) {
                outputShape.setDocumentation(output.getDocumentation());
            }
            javaShapes.put(javaResponseClassName, outputShape);
        }
        return javaShapes;
    }

    private final ShapeModel generateOutputShapeModel(Operation c2jOperationModel, String javaOutputShapeNameOverride, Map<String, Shape> c2jShapes) {
        Output c2jOutputModel = c2jOperationModel.getOutput();
        String c2jOutputShapeName = c2jOutputModel.getShape();
        ShapeModel shapeModel = this.generateShapeModel(javaOutputShapeNameOverride, c2jOutputShapeName);
        shapeModel.setType(ShapeType.Response.getValue());
        ShapeUnmarshaller shapeUnmarshaller = new ShapeUnmarshaller().withFlattened(c2jShapes.get(c2jOutputShapeName).isFlattened()).withResultWrapper(c2jOutputModel.getResultWrapper());
        shapeModel.setUnmarshaller(shapeUnmarshaller);
        return shapeModel;
    }
}

