/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.IntermediateModelBuilder;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.intermediate.ExceptionModel;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ReturnTypeModel;
import com.amazonaws.codegen.model.intermediate.VariableModel;
import com.amazonaws.codegen.model.service.AuthType;
import com.amazonaws.codegen.model.service.ErrorMap;
import com.amazonaws.codegen.model.service.ErrorTrait;
import com.amazonaws.codegen.model.service.Input;
import com.amazonaws.codegen.model.service.Member;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.Output;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import com.amazonaws.codegen.naming.NamingStrategy;
import java.util.Map;
import java.util.TreeMap;

final class AddOperations {
    private final ServiceModel serviceModel;
    private final NamingStrategy namingStrategy;

    public AddOperations(IntermediateModelBuilder builder) {
        this.serviceModel = builder.getService();
        this.namingStrategy = builder.getNamingStrategy();
    }

    public Map<String, OperationModel> constructOperations() {
        TreeMap<String, OperationModel> javaOperationModels = new TreeMap<String, OperationModel>();
        Map<String, Shape> c2jShapes = this.serviceModel.getShapes();
        for (Map.Entry<String, Operation> entry : this.serviceModel.getOperations().entrySet()) {
            Output output;
            String operationName = entry.getKey();
            Operation op = entry.getValue();
            if (this.shouldSkipOperation(op, c2jShapes)) continue;
            OperationModel operationModel = new OperationModel();
            operationModel.setOperationName(operationName);
            operationModel.setDeprecated(op.isDeprecated());
            operationModel.setDocumentation(op.getDocumentation());
            operationModel.setIsAuthenticated(AddOperations.isAuthenticated(op));
            operationModel.setEndpointDiscovery(op.getEndpointdiscovery());
            operationModel.setEndpointOperation(op.isEndpointoperation());
            operationModel.setEndpointTrait(op.getEndpoint());
            Input input = op.getInput();
            if (input != null) {
                String originalShapeName = input.getShape();
                String inputShape = this.namingStrategy.getRequestClassName(operationName);
                String documentation = input.getDocumentation() != null ? input.getDocumentation() : c2jShapes.get(originalShapeName).getDocumentation();
                operationModel.setInput(new VariableModel(Utils.unCapitialize(inputShape), inputShape).withDocumentation(documentation));
            }
            if ((output = op.getOutput()) != null) {
                String outputShapeName = AddOperations.getResultShapeName(op, c2jShapes);
                Shape outputShape = c2jShapes.get(outputShapeName);
                String responseClassName = outputShape.isWrapper() ? outputShapeName : this.namingStrategy.getResponseClassName(operationName);
                String documentation = AddOperations.getOperationDocumentation(output, outputShape);
                operationModel.setReturnType(new ReturnTypeModel(responseClassName).withDocumentation(documentation));
                if (AddOperations.isBlobShape(AddOperations.getPayloadShape(c2jShapes, outputShape))) {
                    operationModel.setHasBlobMemberAsPayload(true);
                }
            }
            if (op.getErrors() != null) {
                for (ErrorMap error : op.getErrors()) {
                    String documentation = error.getDocumentation() != null ? error.getDocumentation() : c2jShapes.get(error.getShape()).getDocumentation();
                    Integer httpStatusCode = this.getHttpStatusCode(error, c2jShapes.get(error.getShape()));
                    operationModel.addException(new ExceptionModel(this.namingStrategy.getExceptionName(error.getShape())).withDocumentation(documentation).withHttpStatusCode(httpStatusCode));
                }
            }
            operationModel.setInputStreamPropertyName(null);
            javaOperationModels.put(operationName, operationModel);
        }
        return javaOperationModels;
    }

    private boolean shouldSkipOperation(Operation operation, Map<String, Shape> c2jShapes) {
        Input operationInput = operation.getInput();
        Output operationOutput = operation.getOutput();
        Shape inputShape = operationInput == null ? null : c2jShapes.get(operationInput.getShape());
        Shape outputShape = operationOutput == null ? null : c2jShapes.get(operationOutput.getShape());
        Shape inputPayloadShape = inputShape == null ? null : AddOperations.getPayloadShape(c2jShapes, inputShape);
        Shape outputPayloadShape = outputShape == null ? null : AddOperations.getPayloadShape(c2jShapes, outputShape);
        boolean hasEventStreamInput = this.hasEventStreamInput(operation, c2jShapes);
        boolean hasEventStreamOutput = this.hasEventStreamOutput(operation, c2jShapes);
        boolean hasStringPayloadInput = inputPayloadShape != null && "String".equals(inputPayloadShape.getType());
        boolean hasStringPayloadOutput = outputPayloadShape != null && "String".equals(outputPayloadShape.getType());
        return hasEventStreamInput || hasEventStreamOutput || hasStringPayloadInput || hasStringPayloadOutput;
    }

    private boolean hasEventStreamOutput(Operation operation, Map<String, Shape> c2jShapes) {
        Output output = operation.getOutput();
        if (output == null) {
            return false;
        }
        return this.hasEventStreamMember(output.getShape(), c2jShapes);
    }

    private boolean hasEventStreamInput(Operation operation, Map<String, Shape> c2jShapes) {
        Output input = operation.getOutput();
        if (input == null) {
            return false;
        }
        return this.hasEventStreamMember(input.getShape(), c2jShapes);
    }

    private boolean hasEventStreamMember(String shape, Map<String, Shape> c2jShapes) {
        Shape outputShape = c2jShapes.get(shape);
        return outputShape.getMembers().values().stream().map(m -> (Shape)c2jShapes.get(m.getShape())).anyMatch(Shape::isEventStream);
    }

    private Integer getHttpStatusCode(ErrorMap error, Shape shape) {
        Integer httpStatusCode = this.getHttpStatusCode(error.getErrorTrait());
        return httpStatusCode == null ? this.getHttpStatusCode(shape.getErrorTrait()) : httpStatusCode;
    }

    private Integer getHttpStatusCode(ErrorTrait errorTrait) {
        return errorTrait == null ? null : errorTrait.getHttpStatusCode();
    }

    private static boolean isAuthenticated(Operation op) {
        return op.getAuthType() == null || !op.getAuthType().equals((Object)AuthType.NONE);
    }

    private static String getOperationDocumentation(Output output, Shape outputShape) {
        return output.getDocumentation() != null ? output.getDocumentation() : outputShape.getDocumentation();
    }

    private static boolean isBlobShape(Shape shape) {
        return shape != null && "blob".equals(shape.getType());
    }

    public static Shape getPayloadShape(Map<String, Shape> c2jShapes, Shape outputShape) {
        if (outputShape.getPayload() == null) {
            return null;
        }
        Member payloadMember = outputShape.getMembers().get(outputShape.getPayload());
        return c2jShapes.get(payloadMember.getShape());
    }

    private static String getResultShapeName(Operation operation, Map<String, Shape> shapes) {
        Output output = operation.getOutput();
        if (output == null) {
            return null;
        }
        Shape outputShape = shapes.get(output.getShape());
        if (outputShape.getMembers().keySet().size() != 1) {
            return output.getShape();
        }
        Member wrappedMember = outputShape.getMembers().values().toArray(new Member[0])[0];
        Shape wrappedResult = shapes.get(wrappedMember.getShape());
        return wrappedResult != null && wrappedResult.isWrapper() ? wrappedMember.getShape() : output.getShape();
    }
}

