/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.naming;

import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.service.Input;
import com.amazonaws.codegen.model.service.Output;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.naming.NamingStrategy;
import com.amazonaws.codegen.utils.ProtocolUtils;
import com.amazonaws.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultNamingStrategy
implements NamingStrategy {
    private static final Set<String> reservedKeywords = new HashSet<String>();
    private final ServiceModel serviceModel;
    private final CustomizationConfig customizationConfig;

    public DefaultNamingStrategy(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        this.serviceModel = serviceModel;
        this.customizationConfig = customizationConfig;
    }

    @Override
    public String getExceptionName(String errorShapeName) {
        if (errorShapeName.endsWith("Fault")) {
            return Utils.capitialize(errorShapeName.substring(0, errorShapeName.length() - "Fault".length()) + "Exception");
        }
        if (errorShapeName.endsWith("Exception")) {
            return Utils.capitialize(errorShapeName);
        }
        return Utils.capitialize(errorShapeName + "Exception");
    }

    @Override
    public String getRequestClassName(String operationName) {
        Input operationInput;
        if (this.customizationConfig.useModeledInputShapeNames() && (operationInput = this.serviceModel.getOperation(operationName).getInput()) != null) {
            return operationInput.getShape();
        }
        return Utils.sanitize(operationName).map(Utils::capitialize).collect(Collectors.joining()) + "Request";
    }

    @Override
    public String getResponseClassName(String operationName) {
        Output operationOutput;
        if (this.customizationConfig.useModeledOutputShapeNames() && (operationOutput = this.serviceModel.getOperation(operationName).getOutput()) != null) {
            return operationOutput.getShape();
        }
        return Utils.sanitize(operationName).map(Utils::capitialize).collect(Collectors.joining()) + "Result";
    }

    @Override
    public String getVariableName(String name) {
        if (DefaultNamingStrategy.isJavaKeyword(name)) {
            return Utils.unCapitialize(name + "Value");
        }
        return Utils.unCapitialize(name);
    }

    @Override
    public String getEnumValueName(String enumValue) {
        StringBuilder builder = new StringBuilder();
        String sanitizedEnumValue = enumValue.replace("::", ":").replace("/", "").replace("(", "").replace(")", "");
        for (String part : sanitizedEnumValue.split("[ -.:]")) {
            if (part.length() > 1) {
                builder.append(StringUtils.upperCase((String)part.substring(0, 1))).append(part.substring(1));
                continue;
            }
            builder.append(StringUtils.upperCase((String)part));
        }
        return builder.toString();
    }

    @Override
    public String getJavaClassName(String shapeName) {
        return Arrays.stream(shapeName.split("[._-]|\\W")).filter(StringUtils::hasValue).map(Utils::capitialize).collect(Collectors.joining());
    }

    @Override
    public String getAuthorizerClassName(String shapeName) {
        String converted = this.getJavaClassName(shapeName);
        if (converted.length() > 0 && !Character.isLetter(converted.charAt(0))) {
            return "I" + converted;
        }
        return converted;
    }

    @Override
    public String getGetterMethodName(String memberName) {
        return String.format("get%s", Utils.capitialize(memberName));
    }

    @Override
    public String getSetterMethodName(String memberName) {
        return String.format("set%s", Utils.capitialize(memberName));
    }

    @Override
    public String getFluentSetterMethodName(String memberName) {
        String protocolValue = ProtocolUtils.resolveProtocol(this.serviceModel.getMetadata());
        if ("api-gateway".equals(protocolValue)) {
            return Utils.unCapitialize(memberName);
        }
        return String.format("with%s", Utils.capitialize(memberName));
    }

    public static boolean isJavaKeyword(String word) {
        return reservedKeywords.contains(word) || reservedKeywords.contains(StringUtils.lowerCase((String)word));
    }

    static {
        Collections.addAll(reservedKeywords, "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "null", "false", "const", "goto");
    }
}

