/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.protocol;

import com.amazonaws.annotation.SdkTestInternalApi;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ProtocolSelector {
    private static final List<String> supportedPriorityOrderedProtocols = Arrays.asList("smithy-rpc-v2-cbor", "json", "rest-json", "rest-xml", "query", "ec2");

    @SdkTestInternalApi
    protected static String selectProtocol(List<String> supportedList, String c2jProtocol, List<String> c2jProtocols) {
        if (c2jProtocol != null && c2jProtocol.equals("api-gateway")) {
            return c2jProtocol;
        }
        if (c2jProtocols != null) {
            int selectedProtocolIdx = supportedList.size();
            block0: for (String listedProtocol : c2jProtocols) {
                for (int i = 0; i < supportedList.size(); ++i) {
                    if (!Objects.equals(listedProtocol, supportedList.get(i)) || i >= selectedProtocolIdx) continue;
                    selectedProtocolIdx = i;
                    continue block0;
                }
            }
            if (selectedProtocolIdx != supportedList.size()) {
                return supportedList.get(selectedProtocolIdx);
            }
            throw new IllegalArgumentException("SDK does not support any of provided protocols: " + c2jProtocols.toString());
        }
        return c2jProtocol;
    }

    public static String selectProtocol(String c2jProtocol, List<String> c2jProtocols) {
        return ProtocolSelector.selectProtocol(supportedPriorityOrderedProtocols, c2jProtocol, c2jProtocols);
    }
}

