/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codebuild.model.ProjectArtifacts;
import com.amazonaws.services.codebuild.model.ProjectCache;
import com.amazonaws.services.codebuild.model.ProjectEnvironment;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.Tag;
import com.amazonaws.services.codebuild.model.VpcConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateProjectRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private ProjectSource source;
    private ProjectArtifacts artifacts;
    private ProjectCache cache;
    private ProjectEnvironment environment;
    private String serviceRole;
    private Integer timeoutInMinutes;
    private String encryptionKey;
    private List<Tag> tags;
    private VpcConfig vpcConfig;
    private Boolean badgeEnabled;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateProjectRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateProjectRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSource(ProjectSource source) {
        this.source = source;
    }

    public ProjectSource getSource() {
        return this.source;
    }

    public CreateProjectRequest withSource(ProjectSource source) {
        this.setSource(source);
        return this;
    }

    public void setArtifacts(ProjectArtifacts artifacts) {
        this.artifacts = artifacts;
    }

    public ProjectArtifacts getArtifacts() {
        return this.artifacts;
    }

    public CreateProjectRequest withArtifacts(ProjectArtifacts artifacts) {
        this.setArtifacts(artifacts);
        return this;
    }

    public void setCache(ProjectCache cache) {
        this.cache = cache;
    }

    public ProjectCache getCache() {
        return this.cache;
    }

    public CreateProjectRequest withCache(ProjectCache cache) {
        this.setCache(cache);
        return this;
    }

    public void setEnvironment(ProjectEnvironment environment) {
        this.environment = environment;
    }

    public ProjectEnvironment getEnvironment() {
        return this.environment;
    }

    public CreateProjectRequest withEnvironment(ProjectEnvironment environment) {
        this.setEnvironment(environment);
        return this;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public CreateProjectRequest withServiceRole(String serviceRole) {
        this.setServiceRole(serviceRole);
        return this;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public CreateProjectRequest withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.setTimeoutInMinutes(timeoutInMinutes);
        return this;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public CreateProjectRequest withEncryptionKey(String encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateProjectRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateProjectRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public CreateProjectRequest withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setBadgeEnabled(Boolean badgeEnabled) {
        this.badgeEnabled = badgeEnabled;
    }

    public Boolean getBadgeEnabled() {
        return this.badgeEnabled;
    }

    public CreateProjectRequest withBadgeEnabled(Boolean badgeEnabled) {
        this.setBadgeEnabled(badgeEnabled);
        return this;
    }

    public Boolean isBadgeEnabled() {
        return this.badgeEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getArtifacts() != null) {
            sb.append("Artifacts: ").append(this.getArtifacts()).append(",");
        }
        if (this.getCache() != null) {
            sb.append("Cache: ").append(this.getCache()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: ").append(this.getServiceRole()).append(",");
        }
        if (this.getTimeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.getTimeoutInMinutes()).append(",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getBadgeEnabled() != null) {
            sb.append("BadgeEnabled: ").append(this.getBadgeEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getArtifacts() == null ^ this.getArtifacts() == null) {
            return false;
        }
        if (other.getArtifacts() != null && !other.getArtifacts().equals(this.getArtifacts())) {
            return false;
        }
        if (other.getCache() == null ^ this.getCache() == null) {
            return false;
        }
        if (other.getCache() != null && !other.getCache().equals(this.getCache())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getBadgeEnabled() == null ^ this.getBadgeEnabled() == null) {
            return false;
        }
        return other.getBadgeEnabled() == null || other.getBadgeEnabled().equals(this.getBadgeEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getArtifacts() == null ? 0 : this.getArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getCache() == null ? 0 : this.getCache().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getBadgeEnabled() == null ? 0 : this.getBadgeEnabled().hashCode());
        return hashCode;
    }

    public CreateProjectRequest clone() {
        return (CreateProjectRequest)super.clone();
    }
}

