/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.BuildBatch;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class BuildBatchMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CURRENTPHASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentPhase").build();
    private static final MarshallingInfo<String> BUILDBATCHSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildBatchStatus").build();
    private static final MarshallingInfo<String> SOURCEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVersion").build();
    private static final MarshallingInfo<String> RESOLVEDSOURCEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resolvedSourceVersion").build();
    private static final MarshallingInfo<String> PROJECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("projectName").build();
    private static final MarshallingInfo<List> PHASES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phases").build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<List> SECONDARYSOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondarySources").build();
    private static final MarshallingInfo<List> SECONDARYSOURCEVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondarySourceVersions").build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifacts").build();
    private static final MarshallingInfo<List> SECONDARYARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondaryArtifacts").build();
    private static final MarshallingInfo<StructuredPojo> CACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cache").build();
    private static final MarshallingInfo<StructuredPojo> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceRole").build();
    private static final MarshallingInfo<StructuredPojo> LOGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logConfig").build();
    private static final MarshallingInfo<Integer> BUILDTIMEOUTINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildTimeoutInMinutes").build();
    private static final MarshallingInfo<Integer> QUEUEDTIMEOUTINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("queuedTimeoutInMinutes").build();
    private static final MarshallingInfo<Boolean> COMPLETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("complete").build();
    private static final MarshallingInfo<String> INITIATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("initiator").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcConfig").build();
    private static final MarshallingInfo<String> ENCRYPTIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionKey").build();
    private static final MarshallingInfo<Long> BUILDBATCHNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildBatchNumber").build();
    private static final MarshallingInfo<List> FILESYSTEMLOCATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileSystemLocations").build();
    private static final MarshallingInfo<StructuredPojo> BUILDBATCHCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildBatchConfig").build();
    private static final MarshallingInfo<List> BUILDGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildGroups").build();
    private static final BuildBatchMarshaller instance = new BuildBatchMarshaller();

    public static BuildBatchMarshaller getInstance() {
        return instance;
    }

    public void marshall(BuildBatch buildBatch, ProtocolMarshaller protocolMarshaller) {
        if (buildBatch == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)buildBatch.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getCurrentPhase(), CURRENTPHASE_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getBuildBatchStatus(), BUILDBATCHSTATUS_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getSourceVersion(), SOURCEVERSION_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getResolvedSourceVersion(), RESOLVEDSOURCEVERSION_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getProjectName(), PROJECTNAME_BINDING);
            protocolMarshaller.marshall(buildBatch.getPhases(), PHASES_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall(buildBatch.getSecondarySources(), SECONDARYSOURCES_BINDING);
            protocolMarshaller.marshall(buildBatch.getSecondarySourceVersions(), SECONDARYSOURCEVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getArtifacts(), ARTIFACTS_BINDING);
            protocolMarshaller.marshall(buildBatch.getSecondaryArtifacts(), SECONDARYARTIFACTS_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getCache(), CACHE_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getEnvironment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getServiceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getLogConfig(), LOGCONFIG_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getBuildTimeoutInMinutes(), BUILDTIMEOUTINMINUTES_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getQueuedTimeoutInMinutes(), QUEUEDTIMEOUTINMINUTES_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getComplete(), COMPLETE_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getInitiator(), INITIATOR_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getVpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getEncryptionKey(), ENCRYPTIONKEY_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getBuildBatchNumber(), BUILDBATCHNUMBER_BINDING);
            protocolMarshaller.marshall(buildBatch.getFileSystemLocations(), FILESYSTEMLOCATIONS_BINDING);
            protocolMarshaller.marshall((Object)buildBatch.getBuildBatchConfig(), BUILDBATCHCONFIG_BINDING);
            protocolMarshaller.marshall(buildBatch.getBuildGroups(), BUILDGROUPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

