/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.maven.plugin;

import com.amazonaws.codegen.ant.task.CodeGeneratorTask;
import com.amazonaws.codegen.maven.plugin.ClassPathUtils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate")
public class GenerationMojo
extends AbstractMojo {
    private static final String P_MODEL_FILE = "modelFile";
    private static final String P_EXAMPLES_FILE = "examplesFile";
    private static final String P_CODEGEN_CONFIG_FILE = "codeGenConfigFile";
    private static final String P_CUSTOMIZATION_CONFIG_FILE = "customizationConfigFile";
    private static final String P_OUTPUT_DIRECTORY = "outputDirectory";
    @Parameter(property="modelFile", required=true, defaultValue="code-gen/model.json")
    private String serviceModelLocation;
    @Parameter(property="codeGenConfigFile", required=true, defaultValue="code-gen/codegen.config")
    private String codeGenConfigLocation;
    @Parameter(property="customizationConfigFile", required=false, defaultValue="code-gen/customization.config")
    private String customizationConfigLocation;
    @Parameter(property="examplesFile", required=false, defaultValue="code-gen/examples.json")
    private String serviceExamplesLocation;
    @Parameter(property="outputDirectory", required=false, defaultValue="${project.build.directory}/generated-src")
    private String outputDirectory;
    @Parameter(property="resourcesDirectory", defaultValue="${basedir}/src/main/resources")
    private String resourcesDirectory;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            ClassPathUtils.addFile(this.resourcesDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setPropertyIfFileExists(P_MODEL_FILE, this.resourcesDirectory, this.serviceModelLocation);
        this.setPropertyIfFileExists(P_CODEGEN_CONFIG_FILE, this.resourcesDirectory, this.codeGenConfigLocation);
        this.setPropertyIfFileExists(P_CUSTOMIZATION_CONFIG_FILE, this.resourcesDirectory, this.customizationConfigLocation);
        this.setPropertyIfFileExists(P_EXAMPLES_FILE, this.resourcesDirectory, this.serviceExamplesLocation);
        System.setProperty(P_OUTPUT_DIRECTORY, this.outputDirectory);
        try {
            CodeGeneratorTask.main((String[])new String[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.project.addCompileSourceRoot(this.outputDirectory);
    }

    private void setPropertyIfFileExists(String propertyKey, String root, String location) {
        if (new File(root + File.separator + location).exists()) {
            System.setProperty(propertyKey, location);
        }
    }
}

