/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurusecurity.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurusecurity.model.MetricsSummary;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class MetricsSummaryMarshaller {
    private static final MarshallingInfo<List> CATEGORIESWITHMOSTFINDINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("categoriesWithMostFindings").build();
    private static final MarshallingInfo<Date> DATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("date").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> OPENFINDINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("openFindings").build();
    private static final MarshallingInfo<List> SCANSWITHMOSTOPENCRITICALFINDINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scansWithMostOpenCriticalFindings").build();
    private static final MarshallingInfo<List> SCANSWITHMOSTOPENFINDINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scansWithMostOpenFindings").build();
    private static final MetricsSummaryMarshaller instance = new MetricsSummaryMarshaller();

    public static MetricsSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricsSummary metricsSummary, ProtocolMarshaller protocolMarshaller) {
        if (metricsSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(metricsSummary.getCategoriesWithMostFindings(), CATEGORIESWITHMOSTFINDINGS_BINDING);
            protocolMarshaller.marshall((Object)metricsSummary.getDate(), DATE_BINDING);
            protocolMarshaller.marshall((Object)metricsSummary.getOpenFindings(), OPENFINDINGS_BINDING);
            protocolMarshaller.marshall(metricsSummary.getScansWithMostOpenCriticalFindings(), SCANSWITHMOSTOPENCRITICALFINDINGS_BINDING);
            protocolMarshaller.marshall(metricsSummary.getScansWithMostOpenFindings(), SCANSWITHMOSTOPENFINDINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

